package zio.aws.cognitosync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteDatasetResponse(
    dataset: Option[zio.aws.cognitosync.model.Dataset] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse = {
    import DeleteDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse
      .builder()
      .optionallyWith(dataset.map(value => value.buildAwsValue()))(_.dataset)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.DeleteDatasetResponse.ReadOnly =
    zio.aws.cognitosync.model.DeleteDatasetResponse.wrap(buildAwsValue())
}
object DeleteDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.DeleteDatasetResponse =
      zio.aws.cognitosync.model
        .DeleteDatasetResponse(dataset.map(value => value.asEditable))
    def dataset: Option[zio.aws.cognitosync.model.Dataset.ReadOnly]
    def getDataset
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.Dataset.ReadOnly] =
      AwsError.unwrapOptionField("dataset", dataset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse
  ) extends zio.aws.cognitosync.model.DeleteDatasetResponse.ReadOnly {
    override val dataset: Option[zio.aws.cognitosync.model.Dataset.ReadOnly] =
      scala
        .Option(impl.dataset())
        .map(value => zio.aws.cognitosync.model.Dataset.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse
  ): zio.aws.cognitosync.model.DeleteDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
