package zio.aws.cognitosync
import zio.aws.cognitosync.model.UpdateRecordsResponse.ReadOnly
import software.amazon.awssdk.services.cognitosync.{
  CognitoSyncAsyncClientBuilder,
  CognitoSyncAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.cognitosync.model.{
  GetIdentityPoolConfigurationResponse,
  DescribeIdentityPoolUsageResponse,
  ListRecordsRequest,
  UnsubscribeFromDatasetResponse,
  ListIdentityPoolUsageRequest,
  RegisterDeviceRequest,
  SetIdentityPoolConfigurationRequest,
  DescribeDatasetResponse,
  DescribeIdentityPoolUsageRequest,
  GetBulkPublishDetailsRequest,
  GetCognitoEventsRequest,
  IdentityPoolUsage,
  SubscribeToDatasetResponse,
  RegisterDeviceResponse,
  UpdateRecordsResponse,
  SetCognitoEventsResponse,
  DescribeDatasetRequest,
  Record,
  GetBulkPublishDetailsResponse,
  ListIdentityPoolUsageResponse,
  SetIdentityPoolConfigurationResponse,
  ListDatasetsRequest,
  SubscribeToDatasetRequest,
  ListRecordsResponse,
  BulkPublishResponse,
  SetCognitoEventsRequest,
  BulkPublishRequest,
  UnsubscribeFromDatasetRequest,
  DeleteDatasetRequest,
  DeleteDatasetResponse,
  GetCognitoEventsResponse,
  Dataset,
  ListDatasetsResponse,
  DescribeIdentityUsageResponse,
  UpdateRecordsRequest,
  GetIdentityPoolConfigurationRequest,
  DescribeIdentityUsageRequest
}
import scala.jdk.CollectionConverters._
trait CognitoSync extends AspectSupport[CognitoSync] {
  val api: CognitoSyncAsyncClient
  def getCognitoEvents(
      request: zio.aws.cognitosync.model.GetCognitoEventsRequest
  ): IO[AwsError, zio.aws.cognitosync.model.GetCognitoEventsResponse.ReadOnly]
  def describeIdentityUsage(
      request: zio.aws.cognitosync.model.DescribeIdentityUsageRequest
  ): IO[
    AwsError,
    zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly
  ]
  def setCognitoEvents(
      request: zio.aws.cognitosync.model.SetCognitoEventsRequest
  ): IO[AwsError, Unit]
  def describeDataset(
      request: zio.aws.cognitosync.model.DescribeDatasetRequest
  ): IO[AwsError, zio.aws.cognitosync.model.DescribeDatasetResponse.ReadOnly]
  def subscribeToDataset(
      request: zio.aws.cognitosync.model.SubscribeToDatasetRequest
  ): IO[AwsError, zio.aws.cognitosync.model.SubscribeToDatasetResponse.ReadOnly]
  def unsubscribeFromDataset(
      request: zio.aws.cognitosync.model.UnsubscribeFromDatasetRequest
  ): IO[
    AwsError,
    zio.aws.cognitosync.model.UnsubscribeFromDatasetResponse.ReadOnly
  ]
  def setIdentityPoolConfiguration(
      request: zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.cognitosync.model.SetIdentityPoolConfigurationResponse.ReadOnly
  ]
  def listDatasets(
      request: zio.aws.cognitosync.model.ListDatasetsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly,
    zio.aws.cognitosync.model.Dataset.ReadOnly
  ]]
  def listDatasetsPaginated(
      request: zio.aws.cognitosync.model.ListDatasetsRequest
  ): IO[AwsError, zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly]
  def listIdentityPoolUsage(
      request: zio.aws.cognitosync.model.ListIdentityPoolUsageRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly,
    zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly
  ]]
  def listIdentityPoolUsagePaginated(
      request: zio.aws.cognitosync.model.ListIdentityPoolUsageRequest
  ): IO[
    AwsError,
    zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly
  ]
  def getIdentityPoolConfiguration(
      request: zio.aws.cognitosync.model.GetIdentityPoolConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly
  ]
  def getBulkPublishDetails(
      request: zio.aws.cognitosync.model.GetBulkPublishDetailsRequest
  ): IO[
    AwsError,
    zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly
  ]
  def listRecords(
      request: zio.aws.cognitosync.model.ListRecordsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly,
    zio.aws.cognitosync.model.Record.ReadOnly
  ]]
  def listRecordsPaginated(
      request: zio.aws.cognitosync.model.ListRecordsRequest
  ): IO[AwsError, zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly]
  def registerDevice(
      request: zio.aws.cognitosync.model.RegisterDeviceRequest
  ): IO[AwsError, zio.aws.cognitosync.model.RegisterDeviceResponse.ReadOnly]
  def describeIdentityPoolUsage(
      request: zio.aws.cognitosync.model.DescribeIdentityPoolUsageRequest
  ): IO[
    AwsError,
    zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse.ReadOnly
  ]
  def deleteDataset(
      request: zio.aws.cognitosync.model.DeleteDatasetRequest
  ): IO[AwsError, zio.aws.cognitosync.model.DeleteDatasetResponse.ReadOnly]
  def bulkPublish(
      request: zio.aws.cognitosync.model.BulkPublishRequest
  ): IO[AwsError, zio.aws.cognitosync.model.BulkPublishResponse.ReadOnly]
  def updateRecords(
      request: zio.aws.cognitosync.model.UpdateRecordsRequest
  ): IO[AwsError, ReadOnly]
}
object CognitoSync {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CognitoSync] = customized(
    identity
  )
  def customized(
      customization: CognitoSyncAsyncClientBuilder => CognitoSyncAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CognitoSync] = managed(
    customization
  ).toLayer
  def managed(
      customization: CognitoSyncAsyncClientBuilder => CognitoSyncAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CognitoSync] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CognitoSyncAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CognitoSyncAsyncClient, CognitoSyncAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        CognitoSyncAsyncClient,
        CognitoSyncAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new CognitoSyncImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CognitoSyncImpl[R](
      override val api: CognitoSyncAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CognitoSync
      with AwsServiceBase[R] {
    override val serviceName: String = "CognitoSync"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CognitoSyncImpl[R1] = new CognitoSyncImpl(api, newAspect, r)
    def getCognitoEvents(
        request: zio.aws.cognitosync.model.GetCognitoEventsRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.GetCognitoEventsResponse.ReadOnly
    ] = asyncRequestResponse[GetCognitoEventsRequest, GetCognitoEventsResponse](
      "getCognitoEvents",
      api.getCognitoEvents
    )(request.buildAwsValue())
      .map(zio.aws.cognitosync.model.GetCognitoEventsResponse.wrap)
      .provideEnvironment(r)
    def describeIdentityUsage(
        request: zio.aws.cognitosync.model.DescribeIdentityUsageRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeIdentityUsageRequest,
      DescribeIdentityUsageResponse
    ]("describeIdentityUsage", api.describeIdentityUsage)(
      request.buildAwsValue()
    ).map(zio.aws.cognitosync.model.DescribeIdentityUsageResponse.wrap)
      .provideEnvironment(r)
    def setCognitoEvents(
        request: zio.aws.cognitosync.model.SetCognitoEventsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[SetCognitoEventsRequest, SetCognitoEventsResponse](
        "setCognitoEvents",
        api.setCognitoEvents
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeDataset(
        request: zio.aws.cognitosync.model.DescribeDatasetRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.DescribeDatasetResponse.ReadOnly
    ] = asyncRequestResponse[DescribeDatasetRequest, DescribeDatasetResponse](
      "describeDataset",
      api.describeDataset
    )(request.buildAwsValue())
      .map(zio.aws.cognitosync.model.DescribeDatasetResponse.wrap)
      .provideEnvironment(r)
    def subscribeToDataset(
        request: zio.aws.cognitosync.model.SubscribeToDatasetRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.SubscribeToDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      SubscribeToDatasetRequest,
      SubscribeToDatasetResponse
    ]("subscribeToDataset", api.subscribeToDataset)(request.buildAwsValue())
      .map(zio.aws.cognitosync.model.SubscribeToDatasetResponse.wrap)
      .provideEnvironment(r)
    def unsubscribeFromDataset(
        request: zio.aws.cognitosync.model.UnsubscribeFromDatasetRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.UnsubscribeFromDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      UnsubscribeFromDatasetRequest,
      UnsubscribeFromDatasetResponse
    ]("unsubscribeFromDataset", api.unsubscribeFromDataset)(
      request.buildAwsValue()
    ).map(zio.aws.cognitosync.model.UnsubscribeFromDatasetResponse.wrap)
      .provideEnvironment(r)
    def setIdentityPoolConfiguration(
        request: zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.SetIdentityPoolConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      SetIdentityPoolConfigurationRequest,
      SetIdentityPoolConfigurationResponse
    ]("setIdentityPoolConfiguration", api.setIdentityPoolConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.cognitosync.model.SetIdentityPoolConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listDatasets(
        request: zio.aws.cognitosync.model.ListDatasetsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly,
      zio.aws.cognitosync.model.Dataset.ReadOnly
    ]] =
      asyncPaginatedRequest[ListDatasetsRequest, ListDatasetsResponse, Dataset](
        "listDatasets",
        api.listDatasets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.datasets().asScala)
      )(request.buildAwsValue())
        .map(result =>
          result
            .mapResponse(zio.aws.cognitosync.model.ListDatasetsResponse.wrap)
            .mapOutput(
              _.map(item => zio.aws.cognitosync.model.Dataset.wrap(item))
            )
            .provideEnvironment(r)
        )
        .provideEnvironment(r)
    def listDatasetsPaginated(
        request: zio.aws.cognitosync.model.ListDatasetsRequest
    ): IO[AwsError, zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly] =
      asyncRequestResponse[ListDatasetsRequest, ListDatasetsResponse](
        "listDatasets",
        api.listDatasets
      )(request.buildAwsValue())
        .map(zio.aws.cognitosync.model.ListDatasetsResponse.wrap)
        .provideEnvironment(r)
    def listIdentityPoolUsage(
        request: zio.aws.cognitosync.model.ListIdentityPoolUsageRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly,
      zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly
    ]] = asyncPaginatedRequest[
      ListIdentityPoolUsageRequest,
      ListIdentityPoolUsageResponse,
      IdentityPoolUsage
    ](
      "listIdentityPoolUsage",
      api.listIdentityPoolUsage,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.identityPoolUsages().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.cognitosync.model.IdentityPoolUsage.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listIdentityPoolUsagePaginated(
        request: zio.aws.cognitosync.model.ListIdentityPoolUsageRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly
    ] = asyncRequestResponse[
      ListIdentityPoolUsageRequest,
      ListIdentityPoolUsageResponse
    ]("listIdentityPoolUsage", api.listIdentityPoolUsage)(
      request.buildAwsValue()
    ).map(zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.wrap)
      .provideEnvironment(r)
    def getIdentityPoolConfiguration(
        request: zio.aws.cognitosync.model.GetIdentityPoolConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetIdentityPoolConfigurationRequest,
      GetIdentityPoolConfigurationResponse
    ]("getIdentityPoolConfiguration", api.getIdentityPoolConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getBulkPublishDetails(
        request: zio.aws.cognitosync.model.GetBulkPublishDetailsRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBulkPublishDetailsRequest,
      GetBulkPublishDetailsResponse
    ]("getBulkPublishDetails", api.getBulkPublishDetails)(
      request.buildAwsValue()
    ).map(zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.wrap)
      .provideEnvironment(r)
    def listRecords(
        request: zio.aws.cognitosync.model.ListRecordsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly,
      zio.aws.cognitosync.model.Record.ReadOnly
    ]] = asyncPaginatedRequest[ListRecordsRequest, ListRecordsResponse, Record](
      "listRecords",
      api.listRecords,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.records().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.cognitosync.model.ListRecordsResponse.wrap)
          .mapOutput(_.map(item => zio.aws.cognitosync.model.Record.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listRecordsPaginated(
        request: zio.aws.cognitosync.model.ListRecordsRequest
    ): IO[AwsError, zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly] =
      asyncRequestResponse[ListRecordsRequest, ListRecordsResponse](
        "listRecords",
        api.listRecords
      )(request.buildAwsValue())
        .map(zio.aws.cognitosync.model.ListRecordsResponse.wrap)
        .provideEnvironment(r)
    def registerDevice(
        request: zio.aws.cognitosync.model.RegisterDeviceRequest
    ): IO[AwsError, zio.aws.cognitosync.model.RegisterDeviceResponse.ReadOnly] =
      asyncRequestResponse[RegisterDeviceRequest, RegisterDeviceResponse](
        "registerDevice",
        api.registerDevice
      )(request.buildAwsValue())
        .map(zio.aws.cognitosync.model.RegisterDeviceResponse.wrap)
        .provideEnvironment(r)
    def describeIdentityPoolUsage(
        request: zio.aws.cognitosync.model.DescribeIdentityPoolUsageRequest
    ): IO[
      AwsError,
      zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeIdentityPoolUsageRequest,
      DescribeIdentityPoolUsageResponse
    ]("describeIdentityPoolUsage", api.describeIdentityPoolUsage)(
      request.buildAwsValue()
    ).map(zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse.wrap)
      .provideEnvironment(r)
    def deleteDataset(
        request: zio.aws.cognitosync.model.DeleteDatasetRequest
    ): IO[AwsError, zio.aws.cognitosync.model.DeleteDatasetResponse.ReadOnly] =
      asyncRequestResponse[DeleteDatasetRequest, DeleteDatasetResponse](
        "deleteDataset",
        api.deleteDataset
      )(request.buildAwsValue())
        .map(zio.aws.cognitosync.model.DeleteDatasetResponse.wrap)
        .provideEnvironment(r)
    def bulkPublish(
        request: zio.aws.cognitosync.model.BulkPublishRequest
    ): IO[AwsError, zio.aws.cognitosync.model.BulkPublishResponse.ReadOnly] =
      asyncRequestResponse[BulkPublishRequest, BulkPublishResponse](
        "bulkPublish",
        api.bulkPublish
      )(request.buildAwsValue())
        .map(zio.aws.cognitosync.model.BulkPublishResponse.wrap)
        .provideEnvironment(r)
    def updateRecords(
        request: zio.aws.cognitosync.model.UpdateRecordsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[UpdateRecordsRequest, UpdateRecordsResponse](
        "updateRecords",
        api.updateRecords
      )(request.buildAwsValue())
        .map(zio.aws.cognitosync.model.UpdateRecordsResponse.wrap)
        .provideEnvironment(r)
  }
  def getCognitoEvents(
      request: zio.aws.cognitosync.model.GetCognitoEventsRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.GetCognitoEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCognitoEvents(request))
  def describeIdentityUsage(
      request: zio.aws.cognitosync.model.DescribeIdentityUsageRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIdentityUsage(request))
  def setCognitoEvents(
      request: zio.aws.cognitosync.model.SetCognitoEventsRequest
  ): ZIO[zio.aws.cognitosync.CognitoSync, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setCognitoEvents(request))
  def describeDataset(
      request: zio.aws.cognitosync.model.DescribeDatasetRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.DescribeDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataset(request))
  def subscribeToDataset(
      request: zio.aws.cognitosync.model.SubscribeToDatasetRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.SubscribeToDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.subscribeToDataset(request))
  def unsubscribeFromDataset(
      request: zio.aws.cognitosync.model.UnsubscribeFromDatasetRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.UnsubscribeFromDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.unsubscribeFromDataset(request))
  def setIdentityPoolConfiguration(
      request: zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.SetIdentityPoolConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setIdentityPoolConfiguration(request))
  def listDatasets(
      request: zio.aws.cognitosync.model.ListDatasetsRequest
  ): ZIO[zio.aws.cognitosync.CognitoSync, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly,
    zio.aws.cognitosync.model.Dataset.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listDatasets(request))
  def listDatasetsPaginated(
      request: zio.aws.cognitosync.model.ListDatasetsRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetsPaginated(request))
  def listIdentityPoolUsage(
      request: zio.aws.cognitosync.model.ListIdentityPoolUsageRequest
  ): ZIO[zio.aws.cognitosync.CognitoSync, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly,
    zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listIdentityPoolUsage(request))
  def listIdentityPoolUsagePaginated(
      request: zio.aws.cognitosync.model.ListIdentityPoolUsageRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdentityPoolUsagePaginated(request))
  def getIdentityPoolConfiguration(
      request: zio.aws.cognitosync.model.GetIdentityPoolConfigurationRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdentityPoolConfiguration(request))
  def getBulkPublishDetails(
      request: zio.aws.cognitosync.model.GetBulkPublishDetailsRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBulkPublishDetails(request))
  def listRecords(
      request: zio.aws.cognitosync.model.ListRecordsRequest
  ): ZIO[zio.aws.cognitosync.CognitoSync, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly,
    zio.aws.cognitosync.model.Record.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listRecords(request))
  def listRecordsPaginated(
      request: zio.aws.cognitosync.model.ListRecordsRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecordsPaginated(request))
  def registerDevice(
      request: zio.aws.cognitosync.model.RegisterDeviceRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.RegisterDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerDevice(request))
  def describeIdentityPoolUsage(
      request: zio.aws.cognitosync.model.DescribeIdentityPoolUsageRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIdentityPoolUsage(request))
  def deleteDataset(
      request: zio.aws.cognitosync.model.DeleteDatasetRequest
  ): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.DeleteDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataset(request))
  def bulkPublish(request: zio.aws.cognitosync.model.BulkPublishRequest): ZIO[
    zio.aws.cognitosync.CognitoSync,
    AwsError,
    zio.aws.cognitosync.model.BulkPublishResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.bulkPublish(request))
  def updateRecords(
      request: zio.aws.cognitosync.model.UpdateRecordsRequest
  ): ZIO[zio.aws.cognitosync.CognitoSync, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateRecords(request))
}
