package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{AssumeRoleArn, ApplicationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PushSync(
    applicationArns: Option[Iterable[ApplicationArn]] = None,
    roleArn: Option[AssumeRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.PushSync = {
    import PushSync.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.PushSync
      .builder()
      .optionallyWith(
        applicationArns.map(value =>
          value.map { item =>
            ApplicationArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.applicationArns)
      .optionallyWith(
        roleArn.map(value => AssumeRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.PushSync.ReadOnly =
    zio.aws.cognitosync.model.PushSync.wrap(buildAwsValue())
}
object PushSync {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.PushSync
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.PushSync =
      zio.aws.cognitosync.model.PushSync(
        applicationArns.map(value => value),
        roleArn.map(value => value)
      )
    def applicationArns: Option[List[ApplicationArn]]
    def roleArn: Option[AssumeRoleArn]
    def getApplicationArns: ZIO[Any, AwsError, List[ApplicationArn]] =
      AwsError.unwrapOptionField("applicationArns", applicationArns)
    def getRoleArn: ZIO[Any, AwsError, AssumeRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.PushSync
  ) extends zio.aws.cognitosync.model.PushSync.ReadOnly {
    override val applicationArns: Option[List[ApplicationArn]] = scala
      .Option(impl.applicationArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitosync.model.primitives.ApplicationArn(item)
        }.toList
      )
    override val roleArn: Option[AssumeRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.cognitosync.model.primitives.AssumeRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.PushSync
  ): zio.aws.cognitosync.model.PushSync.ReadOnly = new Wrapper(impl)
}
