package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{
  Integer,
  Date,
  IdentityPoolId,
  IdentityId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class IdentityUsage(
    identityId: Option[IdentityId] = None,
    identityPoolId: Option[IdentityPoolId] = None,
    lastModifiedDate: Option[Date] = None,
    datasetCount: Option[Integer] = None,
    dataStorage: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.IdentityUsage = {
    import IdentityUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.IdentityUsage
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        datasetCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.datasetCount)
      .optionallyWith(dataStorage.map(value => value: java.lang.Long))(
        _.dataStorage
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.IdentityUsage.ReadOnly =
    zio.aws.cognitosync.model.IdentityUsage.wrap(buildAwsValue())
}
object IdentityUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.IdentityUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.IdentityUsage =
      zio.aws.cognitosync.model.IdentityUsage(
        identityId.map(value => value),
        identityPoolId.map(value => value),
        lastModifiedDate.map(value => value),
        datasetCount.map(value => value),
        dataStorage.map(value => value)
      )
    def identityId: Option[IdentityId]
    def identityPoolId: Option[IdentityPoolId]
    def lastModifiedDate: Option[Date]
    def datasetCount: Option[Integer]
    def dataStorage: Option[Long]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getDatasetCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("datasetCount", datasetCount)
    def getDataStorage: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataStorage", dataStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.IdentityUsage
  ) extends zio.aws.cognitosync.model.IdentityUsage.ReadOnly {
    override val identityId: Option[IdentityId] = scala
      .Option(impl.identityId())
      .map(value => zio.aws.cognitosync.model.primitives.IdentityId(value))
    override val identityPoolId: Option[IdentityPoolId] = scala
      .Option(impl.identityPoolId())
      .map(value => zio.aws.cognitosync.model.primitives.IdentityPoolId(value))
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val datasetCount: Option[Integer] = scala
      .Option(impl.datasetCount())
      .map(value => zio.aws.cognitosync.model.primitives.Integer(value))
    override val dataStorage: Option[Long] =
      scala.Option(impl.dataStorage()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.IdentityUsage
  ): zio.aws.cognitosync.model.IdentityUsage.ReadOnly = new Wrapper(impl)
}
