package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{Date, IdentityPoolId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class IdentityPoolUsage(
    identityPoolId: Option[IdentityPoolId] = None,
    syncSessionsCount: Option[Long] = None,
    dataStorage: Option[Long] = None,
    lastModifiedDate: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage = {
    import IdentityPoolUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(syncSessionsCount.map(value => value: java.lang.Long))(
        _.syncSessionsCount
      )
      .optionallyWith(dataStorage.map(value => value: java.lang.Long))(
        _.dataStorage
      )
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly =
    zio.aws.cognitosync.model.IdentityPoolUsage.wrap(buildAwsValue())
}
object IdentityPoolUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.IdentityPoolUsage =
      zio.aws.cognitosync.model.IdentityPoolUsage(
        identityPoolId.map(value => value),
        syncSessionsCount.map(value => value),
        dataStorage.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def identityPoolId: Option[IdentityPoolId]
    def syncSessionsCount: Option[Long]
    def dataStorage: Option[Long]
    def lastModifiedDate: Option[Date]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getSyncSessionsCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("syncSessionsCount", syncSessionsCount)
    def getDataStorage: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataStorage", dataStorage)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage
  ) extends zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly {
    override val identityPoolId: Option[IdentityPoolId] = scala
      .Option(impl.identityPoolId())
      .map(value => zio.aws.cognitosync.model.primitives.IdentityPoolId(value))
    override val syncSessionsCount: Option[Long] =
      scala.Option(impl.syncSessionsCount()).map(value => value: Long)
    override val dataStorage: Option[Long] =
      scala.Option(impl.dataStorage()).map(value => value: Long)
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage
  ): zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly = new Wrapper(impl)
}
