package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.IdentityPoolId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetIdentityPoolConfigurationRequest(
    identityPoolId: IdentityPoolId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest = {
    import GetIdentityPoolConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.GetIdentityPoolConfigurationRequest.ReadOnly =
    zio.aws.cognitosync.model.GetIdentityPoolConfigurationRequest
      .wrap(buildAwsValue())
}
object GetIdentityPoolConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitosync.model.GetIdentityPoolConfigurationRequest =
      zio.aws.cognitosync.model
        .GetIdentityPoolConfigurationRequest(identityPoolId)
    def identityPoolId: IdentityPoolId
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest
  ) extends zio.aws.cognitosync.model.GetIdentityPoolConfigurationRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest
  ): zio.aws.cognitosync.model.GetIdentityPoolConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
