package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{Date, IdentityPoolId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetBulkPublishDetailsResponse(
    identityPoolId: Option[IdentityPoolId] = None,
    bulkPublishStartTime: Option[Date] = None,
    bulkPublishCompleteTime: Option[Date] = None,
    bulkPublishStatus: Option[zio.aws.cognitosync.model.BulkPublishStatus] =
      None,
    failureMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse = {
    import GetBulkPublishDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        bulkPublishStartTime.map(value => Date.unwrap(value): Instant)
      )(_.bulkPublishStartTime)
      .optionallyWith(
        bulkPublishCompleteTime.map(value => Date.unwrap(value): Instant)
      )(_.bulkPublishCompleteTime)
      .optionallyWith(bulkPublishStatus.map(value => value.unwrap))(
        _.bulkPublishStatus
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly =
    zio.aws.cognitosync.model.GetBulkPublishDetailsResponse
      .wrap(buildAwsValue())
}
object GetBulkPublishDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.GetBulkPublishDetailsResponse =
      zio.aws.cognitosync.model.GetBulkPublishDetailsResponse(
        identityPoolId.map(value => value),
        bulkPublishStartTime.map(value => value),
        bulkPublishCompleteTime.map(value => value),
        bulkPublishStatus.map(value => value),
        failureMessage.map(value => value)
      )
    def identityPoolId: Option[IdentityPoolId]
    def bulkPublishStartTime: Option[Date]
    def bulkPublishCompleteTime: Option[Date]
    def bulkPublishStatus: Option[zio.aws.cognitosync.model.BulkPublishStatus]
    def failureMessage: Option[String]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getBulkPublishStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("bulkPublishStartTime", bulkPublishStartTime)
    def getBulkPublishCompleteTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("bulkPublishCompleteTime", bulkPublishCompleteTime)
    def getBulkPublishStatus
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.BulkPublishStatus] =
      AwsError.unwrapOptionField("bulkPublishStatus", bulkPublishStatus)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse
  ) extends zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly {
    override val identityPoolId: Option[IdentityPoolId] = scala
      .Option(impl.identityPoolId())
      .map(value => zio.aws.cognitosync.model.primitives.IdentityPoolId(value))
    override val bulkPublishStartTime: Option[Date] = scala
      .Option(impl.bulkPublishStartTime())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val bulkPublishCompleteTime: Option[Date] = scala
      .Option(impl.bulkPublishCompleteTime())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val bulkPublishStatus
        : Option[zio.aws.cognitosync.model.BulkPublishStatus] = scala
      .Option(impl.bulkPublishStatus())
      .map(value => zio.aws.cognitosync.model.BulkPublishStatus.wrap(value))
    override val failureMessage: Option[String] =
      scala.Option(impl.failureMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse
  ): zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
