package zio.aws.cognitosync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIdentityPoolUsageResponse(
    identityPoolUsage: Option[zio.aws.cognitosync.model.IdentityPoolUsage] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse = {
    import DescribeIdentityPoolUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse
      .builder()
      .optionallyWith(identityPoolUsage.map(value => value.buildAwsValue()))(
        _.identityPoolUsage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse.ReadOnly =
    zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse
      .wrap(buildAwsValue())
}
object DescribeIdentityPoolUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse =
      zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse(
        identityPoolUsage.map(value => value.asEditable)
      )
    def identityPoolUsage
        : Option[zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly]
    def getIdentityPoolUsage: ZIO[
      Any,
      AwsError,
      zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly
    ] = AwsError.unwrapOptionField("identityPoolUsage", identityPoolUsage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse
  ) extends zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse.ReadOnly {
    override val identityPoolUsage
        : Option[zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly] = scala
      .Option(impl.identityPoolUsage())
      .map(value => zio.aws.cognitosync.model.IdentityPoolUsage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse
  ): zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse.ReadOnly =
    new Wrapper(impl)
}
