package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{Date, DatasetName, IdentityId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Dataset(
    identityId: Option[IdentityId] = None,
    datasetName: Option[DatasetName] = None,
    creationDate: Option[Date] = None,
    lastModifiedDate: Option[Date] = None,
    lastModifiedBy: Option[String] = None,
    dataStorage: Option[Long] = None,
    numRecords: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.Dataset = {
    import Dataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.Dataset
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(creationDate.map(value => Date.unwrap(value): Instant))(
        _.creationDate
      )
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(dataStorage.map(value => value: java.lang.Long))(
        _.dataStorage
      )
      .optionallyWith(numRecords.map(value => value: java.lang.Long))(
        _.numRecords
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.Dataset.ReadOnly =
    zio.aws.cognitosync.model.Dataset.wrap(buildAwsValue())
}
object Dataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.Dataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.Dataset =
      zio.aws.cognitosync.model.Dataset(
        identityId.map(value => value),
        datasetName.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedBy.map(value => value),
        dataStorage.map(value => value),
        numRecords.map(value => value)
      )
    def identityId: Option[IdentityId]
    def datasetName: Option[DatasetName]
    def creationDate: Option[Date]
    def lastModifiedDate: Option[Date]
    def lastModifiedBy: Option[String]
    def dataStorage: Option[Long]
    def numRecords: Option[Long]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getCreationDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getDataStorage: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataStorage", dataStorage)
    def getNumRecords: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("numRecords", numRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.Dataset
  ) extends zio.aws.cognitosync.model.Dataset.ReadOnly {
    override val identityId: Option[IdentityId] = scala
      .Option(impl.identityId())
      .map(value => zio.aws.cognitosync.model.primitives.IdentityId(value))
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value => zio.aws.cognitosync.model.primitives.DatasetName(value))
    override val creationDate: Option[Date] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val lastModifiedBy: Option[String] =
      scala.Option(impl.lastModifiedBy()).map(value => value: String)
    override val dataStorage: Option[Long] =
      scala.Option(impl.dataStorage()).map(value => value: Long)
    override val numRecords: Option[Long] =
      scala.Option(impl.numRecords()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.Dataset
  ): zio.aws.cognitosync.model.Dataset.ReadOnly = new Wrapper(impl)
}
