package zio.aws.cognitosync
import zio.aws.cognitosync.model.UpdateRecordsResponse.ReadOnly
import software.amazon.awssdk.services.cognitosync.CognitoSyncAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.aws.cognitosync.model.{
  ListRecordsRequest,
  ListIdentityPoolUsageRequest,
  RegisterDeviceRequest,
  SetIdentityPoolConfigurationRequest,
  DescribeIdentityPoolUsageRequest,
  GetBulkPublishDetailsRequest,
  GetCognitoEventsRequest,
  DescribeDatasetRequest,
  ListDatasetsRequest,
  SubscribeToDatasetRequest,
  SetCognitoEventsRequest,
  BulkPublishRequest,
  UnsubscribeFromDatasetRequest,
  DeleteDatasetRequest,
  UpdateRecordsRequest,
  GetIdentityPoolConfigurationRequest,
  DescribeIdentityUsageRequest
}
import zio.test.mock.{Proxy, Mock}
object CognitoSyncMock extends Mock[CognitoSync] {
  object GetCognitoEvents
      extends Effect[
        GetCognitoEventsRequest,
        AwsError,
        zio.aws.cognitosync.model.GetCognitoEventsResponse.ReadOnly
      ]
  object DescribeIdentityUsage
      extends Effect[
        DescribeIdentityUsageRequest,
        AwsError,
        zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly
      ]
  object SetCognitoEvents
      extends Effect[SetCognitoEventsRequest, AwsError, Unit]
  object DescribeDataset
      extends Effect[
        DescribeDatasetRequest,
        AwsError,
        zio.aws.cognitosync.model.DescribeDatasetResponse.ReadOnly
      ]
  object SubscribeToDataset
      extends Effect[
        SubscribeToDatasetRequest,
        AwsError,
        zio.aws.cognitosync.model.SubscribeToDatasetResponse.ReadOnly
      ]
  object UnsubscribeFromDataset
      extends Effect[
        UnsubscribeFromDatasetRequest,
        AwsError,
        zio.aws.cognitosync.model.UnsubscribeFromDatasetResponse.ReadOnly
      ]
  object SetIdentityPoolConfiguration
      extends Effect[
        SetIdentityPoolConfigurationRequest,
        AwsError,
        zio.aws.cognitosync.model.SetIdentityPoolConfigurationResponse.ReadOnly
      ]
  object ListDatasets
      extends Effect[ListDatasetsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly,
        zio.aws.cognitosync.model.Dataset.ReadOnly
      ]]
  object ListDatasetsPaginated
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly
      ]
  object ListIdentityPoolUsage
      extends Effect[
        ListIdentityPoolUsageRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly,
          zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly
        ]
      ]
  object ListIdentityPoolUsagePaginated
      extends Effect[
        ListIdentityPoolUsageRequest,
        AwsError,
        zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly
      ]
  object GetIdentityPoolConfiguration
      extends Effect[
        GetIdentityPoolConfigurationRequest,
        AwsError,
        zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly
      ]
  object GetBulkPublishDetails
      extends Effect[
        GetBulkPublishDetailsRequest,
        AwsError,
        zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly
      ]
  object ListRecords
      extends Effect[ListRecordsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly,
        zio.aws.cognitosync.model.Record.ReadOnly
      ]]
  object ListRecordsPaginated
      extends Effect[
        ListRecordsRequest,
        AwsError,
        zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly
      ]
  object RegisterDevice
      extends Effect[
        RegisterDeviceRequest,
        AwsError,
        zio.aws.cognitosync.model.RegisterDeviceResponse.ReadOnly
      ]
  object DescribeIdentityPoolUsage
      extends Effect[
        DescribeIdentityPoolUsageRequest,
        AwsError,
        zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse.ReadOnly
      ]
  object DeleteDataset
      extends Effect[
        DeleteDatasetRequest,
        AwsError,
        zio.aws.cognitosync.model.DeleteDatasetResponse.ReadOnly
      ]
  object BulkPublish
      extends Effect[
        BulkPublishRequest,
        AwsError,
        zio.aws.cognitosync.model.BulkPublishResponse.ReadOnly
      ]
  object UpdateRecords extends Effect[UpdateRecordsRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, CognitoSync] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new CognitoSync {
          val api: CognitoSyncAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : CognitoSync = this
          def getCognitoEvents(request: GetCognitoEventsRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.GetCognitoEventsResponse.ReadOnly
          ] = proxy(GetCognitoEvents, request)
          def describeIdentityUsage(request: DescribeIdentityUsageRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly
          ] = proxy(DescribeIdentityUsage, request)
          def setCognitoEvents(
              request: SetCognitoEventsRequest
          ): IO[AwsError, Unit] = proxy(SetCognitoEvents, request)
          def describeDataset(request: DescribeDatasetRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.DescribeDatasetResponse.ReadOnly
          ] = proxy(DescribeDataset, request)
          def subscribeToDataset(request: SubscribeToDatasetRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.SubscribeToDatasetResponse.ReadOnly
          ] = proxy(SubscribeToDataset, request)
          def unsubscribeFromDataset(
              request: UnsubscribeFromDatasetRequest
          ): IO[
            AwsError,
            zio.aws.cognitosync.model.UnsubscribeFromDatasetResponse.ReadOnly
          ] = proxy(UnsubscribeFromDataset, request)
          def setIdentityPoolConfiguration(
              request: SetIdentityPoolConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.cognitosync.model.SetIdentityPoolConfigurationResponse.ReadOnly
          ] = proxy(SetIdentityPoolConfiguration, request)
          def listDatasets(
              request: ListDatasetsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly,
            zio.aws.cognitosync.model.Dataset.ReadOnly
          ]] = proxy(ListDatasets, request)
          def listDatasetsPaginated(request: ListDatasetsRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly
          ] = proxy(ListDatasetsPaginated, request)
          def listIdentityPoolUsage(
              request: ListIdentityPoolUsageRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly,
            zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly
          ]] = proxy(ListIdentityPoolUsage, request)
          def listIdentityPoolUsagePaginated(
              request: ListIdentityPoolUsageRequest
          ): IO[
            AwsError,
            zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly
          ] = proxy(ListIdentityPoolUsagePaginated, request)
          def getIdentityPoolConfiguration(
              request: GetIdentityPoolConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly
          ] = proxy(GetIdentityPoolConfiguration, request)
          def getBulkPublishDetails(request: GetBulkPublishDetailsRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly
          ] = proxy(GetBulkPublishDetails, request)
          def listRecords(
              request: ListRecordsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly,
            zio.aws.cognitosync.model.Record.ReadOnly
          ]] = proxy(ListRecords, request)
          def listRecordsPaginated(request: ListRecordsRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly
          ] = proxy(ListRecordsPaginated, request)
          def registerDevice(request: RegisterDeviceRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.RegisterDeviceResponse.ReadOnly
          ] = proxy(RegisterDevice, request)
          def describeIdentityPoolUsage(
              request: DescribeIdentityPoolUsageRequest
          ): IO[
            AwsError,
            zio.aws.cognitosync.model.DescribeIdentityPoolUsageResponse.ReadOnly
          ] = proxy(DescribeIdentityPoolUsage, request)
          def deleteDataset(request: DeleteDatasetRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.DeleteDatasetResponse.ReadOnly
          ] = proxy(DeleteDataset, request)
          def bulkPublish(request: BulkPublishRequest): IO[
            AwsError,
            zio.aws.cognitosync.model.BulkPublishResponse.ReadOnly
          ] = proxy(BulkPublish, request)
          def updateRecords(
              request: UpdateRecordsRequest
          ): IO[AwsError, ReadOnly] = proxy(UpdateRecords, request)
        }
      }
    }
    .toLayer
}
