package zio.aws.cognitoidentityprovider
import zio.aws.cognitoidentityprovider.model.primitives.CompletionMessageType.Type
import zio.aws.cognitoidentityprovider.model.primitives.{
  AttributeNameType,
  ScopeType,
  IdpIdentifierType,
  RedirectUrlType,
  AttributeMappingKeyType,
  TagKeysType,
  ClientPermissionType,
  ProviderNameType,
  StringType,
  TagValueType
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AWSAccountIdType extends Subtype[String]
    type AWSAccountIdType =
      zio.aws.cognitoidentityprovider.model.primitives.AWSAccountIdType.Type
    object AccessTokenValidityType extends Subtype[Int]
    type AccessTokenValidityType =
      zio.aws.cognitoidentityprovider.model.primitives.AccessTokenValidityType.Type
    object AccountTakeoverActionNotifyType extends Subtype[Boolean]
    type AccountTakeoverActionNotifyType =
      zio.aws.cognitoidentityprovider.model.primitives.AccountTakeoverActionNotifyType.Type
    object AdminCreateUserUnusedAccountValidityDaysType extends Subtype[Int]
    type AdminCreateUserUnusedAccountValidityDaysType =
      zio.aws.cognitoidentityprovider.model.primitives.AdminCreateUserUnusedAccountValidityDaysType.Type
    object ArnType extends Subtype[String]
    type ArnType = zio.aws.cognitoidentityprovider.model.primitives.ArnType.Type
    object AttributeMappingKeyType extends Subtype[String]
    type AttributeMappingKeyType =
      zio.aws.cognitoidentityprovider.model.primitives.AttributeMappingKeyType.Type
    object AttributeNameType extends Subtype[String]
    type AttributeNameType =
      zio.aws.cognitoidentityprovider.model.primitives.AttributeNameType.Type
    object AttributeValueType extends Subtype[String]
    type AttributeValueType =
      zio.aws.cognitoidentityprovider.model.primitives.AttributeValueType.Type
    object AuthSessionValidityType extends Subtype[Int]
    type AuthSessionValidityType =
      zio.aws.cognitoidentityprovider.model.primitives.AuthSessionValidityType.Type
    object BooleanType extends Subtype[Boolean]
    type BooleanType =
      zio.aws.cognitoidentityprovider.model.primitives.BooleanType.Type
    object CSSType extends Subtype[String]
    type CSSType = zio.aws.cognitoidentityprovider.model.primitives.CSSType.Type
    object CSSVersionType extends Subtype[String]
    type CSSVersionType =
      zio.aws.cognitoidentityprovider.model.primitives.CSSVersionType.Type
    object ClientIdType extends Subtype[String]
    type ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives.ClientIdType.Type
    object ClientNameType extends Subtype[String]
    type ClientNameType =
      zio.aws.cognitoidentityprovider.model.primitives.ClientNameType.Type
    object ClientPermissionType extends Subtype[String]
    type ClientPermissionType =
      zio.aws.cognitoidentityprovider.model.primitives.ClientPermissionType.Type
    object ClientSecretType extends Subtype[String]
    type ClientSecretType =
      zio.aws.cognitoidentityprovider.model.primitives.ClientSecretType.Type
    object CompletionMessageType extends Subtype[String]
    type CompletionMessageType =
      zio.aws.cognitoidentityprovider.model.primitives.CompletionMessageType.Type
    object ConfirmationCodeType extends Subtype[String]
    type ConfirmationCodeType =
      zio.aws.cognitoidentityprovider.model.primitives.ConfirmationCodeType.Type
    object CustomAttributeNameType extends Subtype[String]
    type CustomAttributeNameType =
      zio.aws.cognitoidentityprovider.model.primitives.CustomAttributeNameType.Type
    object DateType extends Subtype[Instant]
    type DateType =
      zio.aws.cognitoidentityprovider.model.primitives.DateType.Type
    object DescriptionType extends Subtype[String]
    type DescriptionType =
      zio.aws.cognitoidentityprovider.model.primitives.DescriptionType.Type
    object DeviceKeyType extends Subtype[String]
    type DeviceKeyType =
      zio.aws.cognitoidentityprovider.model.primitives.DeviceKeyType.Type
    object DeviceNameType extends Subtype[String]
    type DeviceNameType =
      zio.aws.cognitoidentityprovider.model.primitives.DeviceNameType.Type
    object DomainType extends Subtype[String]
    type DomainType =
      zio.aws.cognitoidentityprovider.model.primitives.DomainType.Type
    object DomainVersionType extends Subtype[String]
    type DomainVersionType =
      zio.aws.cognitoidentityprovider.model.primitives.DomainVersionType.Type
    object EmailAddressType extends Subtype[String]
    type EmailAddressType =
      zio.aws.cognitoidentityprovider.model.primitives.EmailAddressType.Type
    object EmailNotificationBodyType extends Subtype[String]
    type EmailNotificationBodyType =
      zio.aws.cognitoidentityprovider.model.primitives.EmailNotificationBodyType.Type
    object EmailNotificationSubjectType extends Subtype[String]
    type EmailNotificationSubjectType =
      zio.aws.cognitoidentityprovider.model.primitives.EmailNotificationSubjectType.Type
    object EmailVerificationMessageByLinkType extends Subtype[String]
    type EmailVerificationMessageByLinkType =
      zio.aws.cognitoidentityprovider.model.primitives.EmailVerificationMessageByLinkType.Type
    object EmailVerificationMessageType extends Subtype[String]
    type EmailVerificationMessageType =
      zio.aws.cognitoidentityprovider.model.primitives.EmailVerificationMessageType.Type
    object EmailVerificationSubjectByLinkType extends Subtype[String]
    type EmailVerificationSubjectByLinkType =
      zio.aws.cognitoidentityprovider.model.primitives.EmailVerificationSubjectByLinkType.Type
    object EmailVerificationSubjectType extends Subtype[String]
    type EmailVerificationSubjectType =
      zio.aws.cognitoidentityprovider.model.primitives.EmailVerificationSubjectType.Type
    object EventIdType extends Subtype[String]
    type EventIdType =
      zio.aws.cognitoidentityprovider.model.primitives.EventIdType.Type
    object ForceAliasCreation extends Subtype[Boolean]
    type ForceAliasCreation =
      zio.aws.cognitoidentityprovider.model.primitives.ForceAliasCreation.Type
    object GenerateSecret extends Subtype[Boolean]
    type GenerateSecret =
      zio.aws.cognitoidentityprovider.model.primitives.GenerateSecret.Type
    object GroupNameType extends Subtype[String]
    type GroupNameType =
      zio.aws.cognitoidentityprovider.model.primitives.GroupNameType.Type
    object HexStringType extends Subtype[String]
    type HexStringType =
      zio.aws.cognitoidentityprovider.model.primitives.HexStringType.Type
    object IdTokenValidityType extends Subtype[Int]
    type IdTokenValidityType =
      zio.aws.cognitoidentityprovider.model.primitives.IdTokenValidityType.Type
    object IdpIdentifierType extends Subtype[String]
    type IdpIdentifierType =
      zio.aws.cognitoidentityprovider.model.primitives.IdpIdentifierType.Type
    object ImageFileType extends Subtype[Chunk[Byte]]
    type ImageFileType =
      zio.aws.cognitoidentityprovider.model.primitives.ImageFileType.Type
    object ImageUrlType extends Subtype[String]
    type ImageUrlType =
      zio.aws.cognitoidentityprovider.model.primitives.ImageUrlType.Type
    object IntegerType extends Subtype[Int]
    type IntegerType =
      zio.aws.cognitoidentityprovider.model.primitives.IntegerType.Type
    object ListProvidersLimitType extends Subtype[Int]
    type ListProvidersLimitType =
      zio.aws.cognitoidentityprovider.model.primitives.ListProvidersLimitType.Type
    object ListResourceServersLimitType extends Subtype[Int]
    type ListResourceServersLimitType =
      zio.aws.cognitoidentityprovider.model.primitives.ListResourceServersLimitType.Type
    object LongType extends Subtype[Long]
    type LongType =
      zio.aws.cognitoidentityprovider.model.primitives.LongType.Type
    object PaginationKey extends Subtype[String]
    type PaginationKey =
      zio.aws.cognitoidentityprovider.model.primitives.PaginationKey.Type
    object PaginationKeyType extends Subtype[String]
    type PaginationKeyType =
      zio.aws.cognitoidentityprovider.model.primitives.PaginationKeyType.Type
    object PasswordPolicyMinLengthType extends Subtype[Int]
    type PasswordPolicyMinLengthType =
      zio.aws.cognitoidentityprovider.model.primitives.PasswordPolicyMinLengthType.Type
    object PasswordType extends Subtype[String]
    type PasswordType =
      zio.aws.cognitoidentityprovider.model.primitives.PasswordType.Type
    object PoolQueryLimitType extends Subtype[Int]
    type PoolQueryLimitType =
      zio.aws.cognitoidentityprovider.model.primitives.PoolQueryLimitType.Type
    object PreSignedUrlType extends Subtype[String]
    type PreSignedUrlType =
      zio.aws.cognitoidentityprovider.model.primitives.PreSignedUrlType.Type
    object PrecedenceType extends Subtype[Int]
    type PrecedenceType =
      zio.aws.cognitoidentityprovider.model.primitives.PrecedenceType.Type
    object PriorityType extends Subtype[Int]
    type PriorityType =
      zio.aws.cognitoidentityprovider.model.primitives.PriorityType.Type
    object ProviderNameType extends Subtype[String]
    type ProviderNameType =
      zio.aws.cognitoidentityprovider.model.primitives.ProviderNameType.Type
    object ProviderNameTypeV2 extends Subtype[String]
    type ProviderNameTypeV2 =
      zio.aws.cognitoidentityprovider.model.primitives.ProviderNameTypeV2.Type
    object QueryLimit extends Subtype[Int]
    type QueryLimit =
      zio.aws.cognitoidentityprovider.model.primitives.QueryLimit.Type
    object QueryLimitType extends Subtype[Int]
    type QueryLimitType =
      zio.aws.cognitoidentityprovider.model.primitives.QueryLimitType.Type
    object RedirectUrlType extends Subtype[String]
    type RedirectUrlType =
      zio.aws.cognitoidentityprovider.model.primitives.RedirectUrlType.Type
    object RefreshTokenValidityType extends Subtype[Int]
    type RefreshTokenValidityType =
      zio.aws.cognitoidentityprovider.model.primitives.RefreshTokenValidityType.Type
    object RegionCodeType extends Subtype[String]
    type RegionCodeType =
      zio.aws.cognitoidentityprovider.model.primitives.RegionCodeType.Type
    object ResourceServerIdentifierType extends Subtype[String]
    type ResourceServerIdentifierType =
      zio.aws.cognitoidentityprovider.model.primitives.ResourceServerIdentifierType.Type
    object ResourceServerNameType extends Subtype[String]
    type ResourceServerNameType =
      zio.aws.cognitoidentityprovider.model.primitives.ResourceServerNameType.Type
    object ResourceServerScopeDescriptionType extends Subtype[String]
    type ResourceServerScopeDescriptionType =
      zio.aws.cognitoidentityprovider.model.primitives.ResourceServerScopeDescriptionType.Type
    object ResourceServerScopeNameType extends Subtype[String]
    type ResourceServerScopeNameType =
      zio.aws.cognitoidentityprovider.model.primitives.ResourceServerScopeNameType.Type
    object S3BucketType extends Subtype[String]
    type S3BucketType =
      zio.aws.cognitoidentityprovider.model.primitives.S3BucketType.Type
    object SESConfigurationSet extends Subtype[String]
    type SESConfigurationSet =
      zio.aws.cognitoidentityprovider.model.primitives.SESConfigurationSet.Type
    object ScopeType extends Subtype[String]
    type ScopeType =
      zio.aws.cognitoidentityprovider.model.primitives.ScopeType.Type
    object SearchPaginationTokenType extends Subtype[String]
    type SearchPaginationTokenType =
      zio.aws.cognitoidentityprovider.model.primitives.SearchPaginationTokenType.Type
    object SecretCodeType extends Subtype[String]
    type SecretCodeType =
      zio.aws.cognitoidentityprovider.model.primitives.SecretCodeType.Type
    object SecretHashType extends Subtype[String]
    type SecretHashType =
      zio.aws.cognitoidentityprovider.model.primitives.SecretHashType.Type
    object SessionType extends Subtype[String]
    type SessionType =
      zio.aws.cognitoidentityprovider.model.primitives.SessionType.Type
    object SmsVerificationMessageType extends Subtype[String]
    type SmsVerificationMessageType =
      zio.aws.cognitoidentityprovider.model.primitives.SmsVerificationMessageType.Type
    object SoftwareTokenMFAUserCodeType extends Subtype[String]
    type SoftwareTokenMFAUserCodeType =
      zio.aws.cognitoidentityprovider.model.primitives.SoftwareTokenMFAUserCodeType.Type
    type StringType = String
    object TagKeysType extends Subtype[String]
    type TagKeysType =
      zio.aws.cognitoidentityprovider.model.primitives.TagKeysType.Type
    object TagValueType extends Subtype[String]
    type TagValueType =
      zio.aws.cognitoidentityprovider.model.primitives.TagValueType.Type
    object TemporaryPasswordValidityDaysType extends Subtype[Int]
    type TemporaryPasswordValidityDaysType =
      zio.aws.cognitoidentityprovider.model.primitives.TemporaryPasswordValidityDaysType.Type
    object TokenModelType extends Subtype[String]
    type TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives.TokenModelType.Type
    object UserFilterType extends Subtype[String]
    type UserFilterType =
      zio.aws.cognitoidentityprovider.model.primitives.UserFilterType.Type
    object UserImportJobIdType extends Subtype[String]
    type UserImportJobIdType =
      zio.aws.cognitoidentityprovider.model.primitives.UserImportJobIdType.Type
    object UserImportJobNameType extends Subtype[String]
    type UserImportJobNameType =
      zio.aws.cognitoidentityprovider.model.primitives.UserImportJobNameType.Type
    object UserPoolIdType extends Subtype[String]
    type UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType.Type
    object UserPoolNameType extends Subtype[String]
    type UserPoolNameType =
      zio.aws.cognitoidentityprovider.model.primitives.UserPoolNameType.Type
    object UsernameType extends Subtype[String]
    type UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives.UsernameType.Type
    object WrappedBooleanType extends Subtype[Boolean]
    type WrappedBooleanType =
      zio.aws.cognitoidentityprovider.model.primitives.WrappedBooleanType.Type
  }
  type AliasAttributesListType =
    List[zio.aws.cognitoidentityprovider.model.AliasAttributeType]
  type AttributeListType =
    List[zio.aws.cognitoidentityprovider.model.AttributeType]
  type AttributeMappingType = Map[AttributeMappingKeyType, StringType]
  type AttributeNameListType = List[AttributeNameType]
  type AttributesRequireVerificationBeforeUpdateType =
    List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
  type AuthEventsType =
    List[zio.aws.cognitoidentityprovider.model.AuthEventType]
  type AuthParametersType = Map[StringType, StringType]
  type BlockedIPRangeListType = List[StringType]
  type CallbackURLsListType = List[RedirectUrlType]
  type ChallengeParametersType = Map[StringType, StringType]
  type ChallengeResponseListType =
    List[zio.aws.cognitoidentityprovider.model.ChallengeResponseType]
  type ChallengeResponsesType = Map[StringType, StringType]
  type ClientMetadataType = Map[StringType, StringType]
  type ClientPermissionListType = List[ClientPermissionType]
  type CodeDeliveryDetailsListType =
    List[zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType]
  type CustomAttributesListType =
    List[zio.aws.cognitoidentityprovider.model.SchemaAttributeType]
  type DeliveryMediumListType =
    List[zio.aws.cognitoidentityprovider.model.DeliveryMediumType]
  type DeviceListType = List[zio.aws.cognitoidentityprovider.model.DeviceType]
  type EventFiltersType =
    List[zio.aws.cognitoidentityprovider.model.EventFilterType]
  type ExplicitAuthFlowsListType =
    List[zio.aws.cognitoidentityprovider.model.ExplicitAuthFlowsType]
  type GroupListType = List[zio.aws.cognitoidentityprovider.model.GroupType]
  type HttpHeaderList = List[zio.aws.cognitoidentityprovider.model.HttpHeader]
  type IdpIdentifiersListType = List[IdpIdentifierType]
  type ListOfStringTypes = List[StringType]
  type LogConfigurationListType =
    List[zio.aws.cognitoidentityprovider.model.LogConfigurationType]
  type LogoutURLsListType = List[RedirectUrlType]
  type MFAOptionListType =
    List[zio.aws.cognitoidentityprovider.model.MFAOptionType]
  type OAuthFlowsType =
    List[zio.aws.cognitoidentityprovider.model.OAuthFlowType]
  type ProviderDetailsType = Map[StringType, StringType]
  type ProvidersListType =
    List[zio.aws.cognitoidentityprovider.model.ProviderDescription]
  type RecoveryMechanismsType =
    List[zio.aws.cognitoidentityprovider.model.RecoveryOptionType]
  type ResourceServerScopeListType =
    List[zio.aws.cognitoidentityprovider.model.ResourceServerScopeType]
  type ResourceServersListType =
    List[zio.aws.cognitoidentityprovider.model.ResourceServerType]
  type SchemaAttributesListType =
    List[zio.aws.cognitoidentityprovider.model.SchemaAttributeType]
  type ScopeListType = List[ScopeType]
  type SearchedAttributeNamesListType = List[AttributeNameType]
  type SkippedIPRangeListType = List[StringType]
  type SupportedIdentityProvidersListType = List[ProviderNameType]
  type UserImportJobsListType =
    List[zio.aws.cognitoidentityprovider.model.UserImportJobType]
  type UserMFASettingListType = List[StringType]
  type UserPoolClientListType =
    List[zio.aws.cognitoidentityprovider.model.UserPoolClientDescription]
  type UserPoolListType =
    List[zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType]
  type UserPoolTagsListType = List[TagKeysType]
  type UserPoolTagsType = Map[TagKeysType, TagValueType]
  type UsernameAttributesListType =
    List[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
  type UsersListType = List[zio.aws.cognitoidentityprovider.model.UserType]
  type VerifiedAttributesListType =
    List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
}
