package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait AttributeDataType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType
}
object AttributeDataType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType
  ): zio.aws.cognitoidentityprovider.model.AttributeDataType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.STRING =>
      val r = String
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.NUMBER =>
      val r = Number
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.DATE_TIME =>
      val r = DateTime
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.BOOLEAN =>
      val r = Boolean
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.AttributeDataType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object String
      extends zio.aws.cognitoidentityprovider.model.AttributeDataType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.STRING
  }
  case object Number
      extends zio.aws.cognitoidentityprovider.model.AttributeDataType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.NUMBER
  }
  case object DateTime
      extends zio.aws.cognitoidentityprovider.model.AttributeDataType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.DATE_TIME
  }
  case object Boolean
      extends zio.aws.cognitoidentityprovider.model.AttributeDataType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeDataType.BOOLEAN
  }
}
