package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  IdpIdentifierType,
  UserPoolIdType,
  AttributeMappingKeyType,
  ProviderNameType,
  StringType
}
import scala.jdk.CollectionConverters._
final case class UpdateIdentityProviderRequest(
    userPoolId: UserPoolIdType,
    providerName: ProviderNameType,
    providerDetails: Optional[Map[StringType, StringType]] = Optional.Absent,
    attributeMapping: Optional[Map[AttributeMappingKeyType, StringType]] =
      Optional.Absent,
    idpIdentifiers: Optional[Iterable[IdpIdentifierType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest = {
    import UpdateIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .providerName(ProviderNameType.unwrap(providerName): java.lang.String)
      .optionallyWith(
        providerDetails.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.providerDetails)
      .optionallyWith(
        attributeMapping.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeMappingKeyType
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributeMapping)
      .optionallyWith(
        idpIdentifiers.map(value =>
          value.map { item =>
            IdpIdentifierType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.idpIdentifiers)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderRequest
      .wrap(buildAwsValue())
}
object UpdateIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderRequest =
      zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderRequest(
        userPoolId,
        providerName,
        providerDetails.map(value => value),
        attributeMapping.map(value => value),
        idpIdentifiers.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def providerName: ProviderNameType
    def providerDetails: Optional[Map[StringType, StringType]]
    def attributeMapping: Optional[Map[AttributeMappingKeyType, StringType]]
    def idpIdentifiers: Optional[List[IdpIdentifierType]]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getProviderName: ZIO[Any, Nothing, ProviderNameType] =
      ZIO.succeed(providerName)
    def getProviderDetails: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("providerDetails", providerDetails)
    def getAttributeMapping
        : ZIO[Any, AwsError, Map[AttributeMappingKeyType, StringType]] =
      AwsError.unwrapOptionField("attributeMapping", attributeMapping)
    def getIdpIdentifiers: ZIO[Any, AwsError, List[IdpIdentifierType]] =
      AwsError.unwrapOptionField("idpIdentifiers", idpIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest
  ) extends zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val providerName: ProviderNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ProviderNameType(impl.providerName())
    override val providerDetails: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerDetails())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val attributeMapping
        : Optional[Map[AttributeMappingKeyType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeMapping())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentityprovider.model.primitives
                .AttributeMappingKeyType(key) -> (value: StringType)
            })
            .toMap
        )
    override val idpIdentifiers: Optional[List[IdpIdentifierType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idpIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives
              .IdpIdentifierType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest
  ): zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
