package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType
import scala.jdk.CollectionConverters._
final case class GetLogDeliveryConfigurationRequest(
    userPoolId: UserPoolIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest = {
    import GetLogDeliveryConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest
      .wrap(buildAwsValue())
}
object GetLogDeliveryConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest =
      zio.aws.cognitoidentityprovider.model
        .GetLogDeliveryConfigurationRequest(userPoolId)
    def userPoolId: UserPoolIdType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest
  ): zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
