package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  ConfirmationCodeType,
  AttributeNameType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class VerifyUserAttributeRequest(
    accessToken: TokenModelType,
    attributeName: AttributeNameType,
    code: ConfirmationCodeType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest = {
    import VerifyUserAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest
      .builder()
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .attributeName(AttributeNameType.unwrap(attributeName): java.lang.String)
      .code(ConfirmationCodeType.unwrap(code): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.VerifyUserAttributeRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.VerifyUserAttributeRequest
      .wrap(buildAwsValue())
}
object VerifyUserAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.VerifyUserAttributeRequest =
      zio.aws.cognitoidentityprovider.model
        .VerifyUserAttributeRequest(accessToken, attributeName, code)
    def accessToken: TokenModelType
    def attributeName: AttributeNameType
    def code: ConfirmationCodeType
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
    def getAttributeName: ZIO[Any, Nothing, AttributeNameType] =
      ZIO.succeed(attributeName)
    def getCode: ZIO[Any, Nothing, ConfirmationCodeType] = ZIO.succeed(code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest
  ) extends zio.aws.cognitoidentityprovider.model.VerifyUserAttributeRequest.ReadOnly {
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
    override val attributeName: AttributeNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .AttributeNameType(impl.attributeName())
    override val code: ConfirmationCodeType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ConfirmationCodeType(impl.code())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest
  ): zio.aws.cognitoidentityprovider.model.VerifyUserAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
