package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.WrappedBooleanType
import scala.jdk.CollectionConverters._
final case class EventRiskType(
    riskDecision: Optional[
      zio.aws.cognitoidentityprovider.model.RiskDecisionType
    ] = Optional.Absent,
    riskLevel: Optional[zio.aws.cognitoidentityprovider.model.RiskLevelType] =
      Optional.Absent,
    compromisedCredentialsDetected: Optional[WrappedBooleanType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType = {
    import EventRiskType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType
      .builder()
      .optionallyWith(riskDecision.map(value => value.unwrap))(_.riskDecision)
      .optionallyWith(riskLevel.map(value => value.unwrap))(_.riskLevel)
      .optionallyWith(
        compromisedCredentialsDetected.map(value =>
          WrappedBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.compromisedCredentialsDetected)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.EventRiskType.wrap(buildAwsValue())
}
object EventRiskType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.EventRiskType =
      zio.aws.cognitoidentityprovider.model.EventRiskType(
        riskDecision.map(value => value),
        riskLevel.map(value => value),
        compromisedCredentialsDetected.map(value => value)
      )
    def riskDecision
        : Optional[zio.aws.cognitoidentityprovider.model.RiskDecisionType]
    def riskLevel: Optional[zio.aws.cognitoidentityprovider.model.RiskLevelType]
    def compromisedCredentialsDetected: Optional[WrappedBooleanType]
    def getRiskDecision: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.RiskDecisionType
    ] = AwsError.unwrapOptionField("riskDecision", riskDecision)
    def getRiskLevel: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.RiskLevelType
    ] = AwsError.unwrapOptionField("riskLevel", riskLevel)
    def getCompromisedCredentialsDetected
        : ZIO[Any, AwsError, WrappedBooleanType] = AwsError.unwrapOptionField(
      "compromisedCredentialsDetected",
      compromisedCredentialsDetected
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType
  ) extends zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly {
    override val riskDecision
        : Optional[zio.aws.cognitoidentityprovider.model.RiskDecisionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.riskDecision())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.RiskDecisionType.wrap(value)
        )
    override val riskLevel
        : Optional[zio.aws.cognitoidentityprovider.model.RiskLevelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.riskLevel())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.RiskLevelType.wrap(value)
        )
    override val compromisedCredentialsDetected: Optional[WrappedBooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compromisedCredentialsDetected())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .WrappedBooleanType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.EventRiskType
  ): zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly = new Wrapper(
    impl
  )
}
