package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  PaginationKey,
  QueryLimitType,
  GroupNameType,
  UserPoolIdType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUsersInGroupRequest(
    userPoolId: UserPoolIdType,
    groupName: GroupNameType,
    limit: Optional[QueryLimitType] = Optional.Absent,
    nextToken: Optional[PaginationKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest = {
    import ListUsersInGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .optionallyWith(
        limit.map(value => QueryLimitType.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest
      .wrap(buildAwsValue())
}
object ListUsersInGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest =
      zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest(
        userPoolId,
        groupName,
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def groupName: GroupNameType
    def limit: Optional[QueryLimitType]
    def nextToken: Optional[PaginationKey]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getLimit: ZIO[Any, AwsError, QueryLimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val groupName: GroupNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .GroupNameType(impl.groupName())
    override val limit: Optional[QueryLimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.QueryLimitType(value)
      )
    override val nextToken: Optional[PaginationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest
  ): zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest.ReadOnly =
    new Wrapper(impl)
}
