package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  ClientIdType,
  StringType
}
import scala.jdk.CollectionConverters._
final case class InitiateAuthRequest(
    authFlow: zio.aws.cognitoidentityprovider.model.AuthFlowType,
    authParameters: Optional[Map[StringType, StringType]] = Optional.Absent,
    clientMetadata: Optional[Map[StringType, StringType]] = Optional.Absent,
    clientId: ClientIdType,
    analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType
    ] = Optional.Absent,
    userContextData: Optional[
      zio.aws.cognitoidentityprovider.model.UserContextDataType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest = {
    import InitiateAuthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest
      .builder()
      .authFlow(authFlow.unwrap)
      .optionallyWith(
        authParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.authParameters)
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .optionallyWith(analyticsMetadata.map(value => value.buildAwsValue()))(
        _.analyticsMetadata
      )
      .optionallyWith(userContextData.map(value => value.buildAwsValue()))(
        _.userContextData
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.InitiateAuthRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.InitiateAuthRequest
      .wrap(buildAwsValue())
}
object InitiateAuthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.InitiateAuthRequest =
      zio.aws.cognitoidentityprovider.model.InitiateAuthRequest(
        authFlow,
        authParameters.map(value => value),
        clientMetadata.map(value => value),
        clientId,
        analyticsMetadata.map(value => value.asEditable),
        userContextData.map(value => value.asEditable)
      )
    def authFlow: zio.aws.cognitoidentityprovider.model.AuthFlowType
    def authParameters: Optional[Map[StringType, StringType]]
    def clientMetadata: Optional[Map[StringType, StringType]]
    def clientId: ClientIdType
    def analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ]
    def userContextData: Optional[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ]
    def getAuthFlow: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.AuthFlowType
    ] = ZIO.succeed(authFlow)
    def getAuthParameters: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("authParameters", authParameters)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
    def getAnalyticsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("analyticsMetadata", analyticsMetadata)
    def getUserContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("userContextData", userContextData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest
  ) extends zio.aws.cognitoidentityprovider.model.InitiateAuthRequest.ReadOnly {
    override val authFlow: zio.aws.cognitoidentityprovider.model.AuthFlowType =
      zio.aws.cognitoidentityprovider.model.AuthFlowType.wrap(impl.authFlow())
    override val authParameters: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val clientMetadata: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
    override val analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.analyticsMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.wrap(value)
      )
    override val userContextData: Optional[
      zio.aws.cognitoidentityprovider.model.UserContextDataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userContextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserContextDataType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest
  ): zio.aws.cognitoidentityprovider.model.InitiateAuthRequest.ReadOnly =
    new Wrapper(impl)
}
