package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.TokenModelType
import scala.jdk.CollectionConverters._
final case class SetUserMfaPreferenceRequest(
    smsMfaSettings: Optional[
      zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType
    ] = Optional.Absent,
    softwareTokenMfaSettings: Optional[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType
    ] = Optional.Absent,
    accessToken: TokenModelType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest = {
    import SetUserMfaPreferenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest
      .builder()
      .optionallyWith(smsMfaSettings.map(value => value.buildAwsValue()))(
        _.smsMfaSettings
      )
      .optionallyWith(
        softwareTokenMfaSettings.map(value => value.buildAwsValue())
      )(_.softwareTokenMfaSettings)
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceRequest
      .wrap(buildAwsValue())
}
object SetUserMfaPreferenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceRequest =
      zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceRequest(
        smsMfaSettings.map(value => value.asEditable),
        softwareTokenMfaSettings.map(value => value.asEditable),
        accessToken
      )
    def smsMfaSettings: Optional[
      zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.ReadOnly
    ]
    def softwareTokenMfaSettings: Optional[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType.ReadOnly
    ]
    def accessToken: TokenModelType
    def getSmsMfaSettings: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.ReadOnly
    ] = AwsError.unwrapOptionField("smsMfaSettings", smsMfaSettings)
    def getSoftwareTokenMfaSettings: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "softwareTokenMfaSettings",
      softwareTokenMfaSettings
    )
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest
  ) extends zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceRequest.ReadOnly {
    override val smsMfaSettings: Optional[
      zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.smsMfaSettings())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.wrap(value)
      )
    override val softwareTokenMfaSettings: Optional[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.softwareTokenMfaSettings())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType
          .wrap(value)
      )
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest
  ): zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceRequest.ReadOnly =
    new Wrapper(impl)
}
