package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  ProviderNameType
}
import scala.jdk.CollectionConverters._
final case class ProviderUserIdentifierType(
    providerName: Optional[ProviderNameType] = Optional.Absent,
    providerAttributeName: Optional[StringType] = Optional.Absent,
    providerAttributeValue: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderUserIdentifierType = {
    import ProviderUserIdentifierType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderUserIdentifierType
      .builder()
      .optionallyWith(
        providerName.map(value =>
          ProviderNameType.unwrap(value): java.lang.String
        )
      )(_.providerName)
      .optionallyWith(
        providerAttributeName.map(value => value: java.lang.String)
      )(_.providerAttributeName)
      .optionallyWith(
        providerAttributeValue.map(value => value: java.lang.String)
      )(_.providerAttributeValue)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType
      .wrap(buildAwsValue())
}
object ProviderUserIdentifierType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderUserIdentifierType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType =
      zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType(
        providerName.map(value => value),
        providerAttributeName.map(value => value),
        providerAttributeValue.map(value => value)
      )
    def providerName: Optional[ProviderNameType]
    def providerAttributeName: Optional[StringType]
    def providerAttributeValue: Optional[StringType]
    def getProviderName: ZIO[Any, AwsError, ProviderNameType] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getProviderAttributeName: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("providerAttributeName", providerAttributeName)
    def getProviderAttributeValue: ZIO[Any, AwsError, StringType] = AwsError
      .unwrapOptionField("providerAttributeValue", providerAttributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderUserIdentifierType
  ) extends zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly {
    override val providerName: Optional[ProviderNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerName())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .ProviderNameType(value)
        )
    override val providerAttributeName: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerAttributeName())
        .map(value => value: StringType)
    override val providerAttributeValue: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerAttributeValue())
        .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderUserIdentifierType
  ): zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly =
    new Wrapper(impl)
}
