package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait DeliveryMediumType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType
}
object DeliveryMediumType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType
  ): zio.aws.cognitoidentityprovider.model.DeliveryMediumType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType.SMS =>
      val r = SMS
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType.EMAIL =>
      val r = EMAIL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.DeliveryMediumType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType.UNKNOWN_TO_SDK_VERSION
  }
  case object SMS
      extends zio.aws.cognitoidentityprovider.model.DeliveryMediumType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType.SMS
  }
  case object EMAIL
      extends zio.aws.cognitoidentityprovider.model.DeliveryMediumType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType.EMAIL
  }
}
