package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDeviceResponse(
    device: zio.aws.cognitoidentityprovider.model.DeviceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse = {
    import GetDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse
      .builder()
      .device(device.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetDeviceResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetDeviceResponse
      .wrap(buildAwsValue())
}
object GetDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GetDeviceResponse =
      zio.aws.cognitoidentityprovider.model.GetDeviceResponse(device.asEditable)
    def device: zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly
    def getDevice: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly
    ] = ZIO.succeed(device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse
  ) extends zio.aws.cognitoidentityprovider.model.GetDeviceResponse.ReadOnly {
    override val device
        : zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.DeviceType.wrap(impl.device())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse
  ): zio.aws.cognitoidentityprovider.model.GetDeviceResponse.ReadOnly =
    new Wrapper(impl)
}
