package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  ResourceServerIdentifierType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class DeleteResourceServerRequest(
    userPoolId: UserPoolIdType,
    identifier: ResourceServerIdentifierType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest = {
    import DeleteResourceServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .identifier(
        ResourceServerIdentifierType.unwrap(identifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DeleteResourceServerRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeleteResourceServerRequest
      .wrap(buildAwsValue())
}
object DeleteResourceServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DeleteResourceServerRequest =
      zio.aws.cognitoidentityprovider.model
        .DeleteResourceServerRequest(userPoolId, identifier)
    def userPoolId: UserPoolIdType
    def identifier: ResourceServerIdentifierType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getIdentifier: ZIO[Any, Nothing, ResourceServerIdentifierType] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest
  ) extends zio.aws.cognitoidentityprovider.model.DeleteResourceServerRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val identifier: ResourceServerIdentifierType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ResourceServerIdentifierType(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest
  ): zio.aws.cognitoidentityprovider.model.DeleteResourceServerRequest.ReadOnly =
    new Wrapper(impl)
}
