package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  IdpIdentifierType,
  DateType,
  UserPoolIdType,
  AttributeMappingKeyType,
  ProviderNameType,
  StringType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class IdentityProviderType(
    userPoolId: Optional[UserPoolIdType] = Optional.Absent,
    providerName: Optional[ProviderNameType] = Optional.Absent,
    providerType: Optional[
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = Optional.Absent,
    providerDetails: Optional[Map[StringType, StringType]] = Optional.Absent,
    attributeMapping: Optional[Map[AttributeMappingKeyType, StringType]] =
      Optional.Absent,
    idpIdentifiers: Optional[Iterable[IdpIdentifierType]] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType = {
    import IdentityProviderType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        providerName.map(value =>
          ProviderNameType.unwrap(value): java.lang.String
        )
      )(_.providerName)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(
        providerDetails.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.providerDetails)
      .optionallyWith(
        attributeMapping.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeMappingKeyType.unwrap(
                key
              ): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributeMapping)
      .optionallyWith(
        idpIdentifiers.map(value =>
          value.map { item =>
            IdpIdentifierType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.idpIdentifiers)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.IdentityProviderType
      .wrap(buildAwsValue())
}
object IdentityProviderType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.IdentityProviderType =
      zio.aws.cognitoidentityprovider.model.IdentityProviderType(
        userPoolId.map(value => value),
        providerName.map(value => value),
        providerType.map(value => value),
        providerDetails.map(value => value),
        attributeMapping.map(value => value),
        idpIdentifiers.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value)
      )
    def userPoolId: Optional[UserPoolIdType]
    def providerName: Optional[ProviderNameType]
    def providerType: Optional[
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ]
    def providerDetails: Optional[Map[StringType, StringType]]
    def attributeMapping: Optional[Map[AttributeMappingKeyType, StringType]]
    def idpIdentifiers: Optional[List[IdpIdentifierType]]
    def lastModifiedDate: Optional[DateType]
    def creationDate: Optional[DateType]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getProviderName: ZIO[Any, AwsError, ProviderNameType] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getProviderType: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = AwsError.unwrapOptionField("providerType", providerType)
    def getProviderDetails: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("providerDetails", providerDetails)
    def getAttributeMapping
        : ZIO[Any, AwsError, Map[AttributeMappingKeyType, StringType]] =
      AwsError.unwrapOptionField("attributeMapping", attributeMapping)
    def getIdpIdentifiers: ZIO[Any, AwsError, List[IdpIdentifierType]] =
      AwsError.unwrapOptionField("idpIdentifiers", idpIdentifiers)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType
  ) extends zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly {
    override val userPoolId: Optional[UserPoolIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val providerName: Optional[ProviderNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerName())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .ProviderNameType(value)
        )
    override val providerType: Optional[
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.providerType())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
          .wrap(value)
      )
    override val providerDetails: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerDetails())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val attributeMapping
        : Optional[Map[AttributeMappingKeyType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeMapping())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentityprovider.model.primitives
                .AttributeMappingKeyType(key) -> (value: StringType)
            })
            .toMap
        )
    override val idpIdentifiers: Optional[List[IdpIdentifierType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idpIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives
              .IdpIdentifierType(item)
          }.toList
        )
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType
  ): zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly =
    new Wrapper(impl)
}
