package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  ClientIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class DescribeUserPoolClientRequest(
    userPoolId: UserPoolIdType,
    clientId: ClientIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest = {
    import DescribeUserPoolClientRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientRequest
      .wrap(buildAwsValue())
}
object DescribeUserPoolClientRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientRequest =
      zio.aws.cognitoidentityprovider.model
        .DescribeUserPoolClientRequest(userPoolId, clientId)
    def userPoolId: UserPoolIdType
    def clientId: ClientIdType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest
  ) extends zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest
  ): zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientRequest.ReadOnly =
    new Wrapper(impl)
}
