package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeRiskConfigurationResponse(
    riskConfiguration: zio.aws.cognitoidentityprovider.model.RiskConfigurationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse = {
    import DescribeRiskConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse
      .builder()
      .riskConfiguration(riskConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeRiskConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse =
      zio.aws.cognitoidentityprovider.model
        .DescribeRiskConfigurationResponse(riskConfiguration.asEditable)
    def riskConfiguration
        : zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly
    def getRiskConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly
    ] = ZIO.succeed(riskConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse
  ) extends zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse.ReadOnly {
    override val riskConfiguration
        : zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.RiskConfigurationType
        .wrap(impl.riskConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse
  ): zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
