package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  GroupNameType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminRemoveUserFromGroupRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    groupName: GroupNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest = {
    import AdminRemoveUserFromGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest
      .wrap(buildAwsValue())
}
object AdminRemoveUserFromGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest =
      zio.aws.cognitoidentityprovider.model
        .AdminRemoveUserFromGroupRequest(userPoolId, username, groupName)
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def groupName: GroupNameType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val groupName: GroupNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .GroupNameType(impl.groupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest
  ): zio.aws.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest.ReadOnly =
    new Wrapper(impl)
}
