package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartUserImportJobResponse(
    userImportJob: Optional[
      zio.aws.cognitoidentityprovider.model.UserImportJobType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse = {
    import StartUserImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse
      .builder()
      .optionallyWith(userImportJob.map(value => value.buildAwsValue()))(
        _.userImportJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse
      .wrap(buildAwsValue())
}
object StartUserImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse =
      zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse(
        userImportJob.map(value => value.asEditable)
      )
    def userImportJob: Optional[
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ]
    def getUserImportJob: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ] = AwsError.unwrapOptionField("userImportJob", userImportJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse
  ) extends zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse.ReadOnly {
    override val userImportJob: Optional[
      zio.aws.cognitoidentityprovider.model.UserImportJobType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userImportJob())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserImportJobType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse
  ): zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
