package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait EventResponseType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType
}
object EventResponseType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType
  ): zio.aws.cognitoidentityprovider.model.EventResponseType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.PASS =>
      val r = Pass
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.FAIL =>
      val r = Fail
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.IN_PROGRESS =>
      val r = InProgress
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.EventResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.UNKNOWN_TO_SDK_VERSION
  }
  case object Pass
      extends zio.aws.cognitoidentityprovider.model.EventResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.PASS
  }
  case object Fail
      extends zio.aws.cognitoidentityprovider.model.EventResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.FAIL
  }
  case object InProgress
      extends zio.aws.cognitoidentityprovider.model.EventResponseType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventResponseType.IN_PROGRESS
  }
}
