package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType
import scala.jdk.CollectionConverters._
final case class AddCustomAttributesRequest(
    userPoolId: UserPoolIdType,
    customAttributes: Iterable[
      zio.aws.cognitoidentityprovider.model.SchemaAttributeType
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest = {
    import AddCustomAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .customAttributes(customAttributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AddCustomAttributesRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AddCustomAttributesRequest
      .wrap(buildAwsValue())
}
object AddCustomAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AddCustomAttributesRequest =
      zio.aws.cognitoidentityprovider.model.AddCustomAttributesRequest(
        userPoolId,
        customAttributes.map { item =>
          item.asEditable
        }
      )
    def userPoolId: UserPoolIdType
    def customAttributes: List[
      zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly
    ]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getCustomAttributes: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly
    ]] = ZIO.succeed(customAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest
  ) extends zio.aws.cognitoidentityprovider.model.AddCustomAttributesRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val customAttributes: List[
      zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly
    ] = impl
      .customAttributes()
      .asScala
      .map { item =>
        zio.aws.cognitoidentityprovider.model.SchemaAttributeType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest
  ): zio.aws.cognitoidentityprovider.model.AddCustomAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
