package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait IdentityProviderTypeType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType
}
object IdentityProviderTypeType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType
  ): zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.SAML =>
        val r = SAML
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.FACEBOOK =>
        val r = Facebook
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.GOOGLE =>
        val r = Google
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.LOGIN_WITH_AMAZON =>
        val r = LoginWithAmazon
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.SIGN_IN_WITH_APPLE =>
        val r = SignInWithApple
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.OIDC =>
        val r = OIDC
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.UNKNOWN_TO_SDK_VERSION
  }
  case object SAML
      extends zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.SAML
  }
  case object Facebook
      extends zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.FACEBOOK
  }
  case object Google
      extends zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.GOOGLE
  }
  case object LoginWithAmazon
      extends zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.LOGIN_WITH_AMAZON
  }
  case object SignInWithApple
      extends zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.SIGN_IN_WITH_APPLE
  }
  case object OIDC
      extends zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType.OIDC
  }
}
