package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UserImportJobIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class DescribeUserImportJobRequest(
    userPoolId: UserPoolIdType,
    jobId: UserImportJobIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest = {
    import DescribeUserImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .jobId(UserImportJobIdType.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DescribeUserImportJobRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DescribeUserImportJobRequest
      .wrap(buildAwsValue())
}
object DescribeUserImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DescribeUserImportJobRequest =
      zio.aws.cognitoidentityprovider.model
        .DescribeUserImportJobRequest(userPoolId, jobId)
    def userPoolId: UserPoolIdType
    def jobId: UserImportJobIdType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getJobId: ZIO[Any, Nothing, UserImportJobIdType] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest
  ) extends zio.aws.cognitoidentityprovider.model.DescribeUserImportJobRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val jobId: UserImportJobIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserImportJobIdType(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest
  ): zio.aws.cognitoidentityprovider.model.DescribeUserImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
