package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  TagValueType,
  TagKeysType,
  ArnType
}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ArnType,
    tags: Map[TagKeysType, TagValueType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest
      .builder()
      .resourceArn(ArnType.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.TagResourceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.TagResourceRequest
      .wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.TagResourceRequest =
      zio.aws.cognitoidentityprovider.model
        .TagResourceRequest(resourceArn, tags)
    def resourceArn: ArnType
    def tags: Map[TagKeysType, TagValueType]
    def getResourceArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKeysType, TagValueType]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest
  ) extends zio.aws.cognitoidentityprovider.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ArnType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ArnType(impl.resourceArn())
    override val tags: Map[TagKeysType, TagValueType] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.cognitoidentityprovider.model.primitives
          .TagKeysType(key) -> zio.aws.cognitoidentityprovider.model.primitives
          .TagValueType(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest
  ): zio.aws.cognitoidentityprovider.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
