package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType
import scala.jdk.CollectionConverters._
final case class LogDeliveryConfigurationType(
    userPoolId: UserPoolIdType,
    logConfigurations: Iterable[
      zio.aws.cognitoidentityprovider.model.LogConfigurationType
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.LogDeliveryConfigurationType = {
    import LogDeliveryConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.LogDeliveryConfigurationType
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .logConfigurations(logConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType
      .wrap(buildAwsValue())
}
object LogDeliveryConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.LogDeliveryConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType =
      zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType(
        userPoolId,
        logConfigurations.map { item =>
          item.asEditable
        }
      )
    def userPoolId: UserPoolIdType
    def logConfigurations: List[
      zio.aws.cognitoidentityprovider.model.LogConfigurationType.ReadOnly
    ]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getLogConfigurations: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.LogConfigurationType.ReadOnly
    ]] = ZIO.succeed(logConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.LogDeliveryConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val logConfigurations: List[
      zio.aws.cognitoidentityprovider.model.LogConfigurationType.ReadOnly
    ] = impl
      .logConfigurations()
      .asScala
      .map { item =>
        zio.aws.cognitoidentityprovider.model.LogConfigurationType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.LogDeliveryConfigurationType
  ): zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType.ReadOnly =
    new Wrapper(impl)
}
