package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  ProviderNameTypeV2,
  IdpIdentifierType,
  UserPoolIdType,
  AttributeMappingKeyType,
  StringType
}
import scala.jdk.CollectionConverters._
final case class CreateIdentityProviderRequest(
    userPoolId: UserPoolIdType,
    providerName: ProviderNameTypeV2,
    providerType: zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType,
    providerDetails: Map[StringType, StringType],
    attributeMapping: Optional[Map[AttributeMappingKeyType, StringType]] =
      Optional.Absent,
    idpIdentifiers: Optional[Iterable[IdpIdentifierType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest = {
    import CreateIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .providerName(ProviderNameTypeV2.unwrap(providerName): java.lang.String)
      .providerType(providerType.unwrap)
      .providerDetails(
        providerDetails
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        attributeMapping.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeMappingKeyType
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributeMapping)
      .optionallyWith(
        idpIdentifiers.map(value =>
          value.map { item =>
            IdpIdentifierType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.idpIdentifiers)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateIdentityProviderRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateIdentityProviderRequest
      .wrap(buildAwsValue())
}
object CreateIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateIdentityProviderRequest =
      zio.aws.cognitoidentityprovider.model.CreateIdentityProviderRequest(
        userPoolId,
        providerName,
        providerType,
        providerDetails,
        attributeMapping.map(value => value),
        idpIdentifiers.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def providerName: ProviderNameTypeV2
    def providerType
        : zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    def providerDetails: Map[StringType, StringType]
    def attributeMapping: Optional[Map[AttributeMappingKeyType, StringType]]
    def idpIdentifiers: Optional[List[IdpIdentifierType]]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getProviderName: ZIO[Any, Nothing, ProviderNameTypeV2] =
      ZIO.succeed(providerName)
    def getProviderType: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = ZIO.succeed(providerType)
    def getProviderDetails: ZIO[Any, Nothing, Map[StringType, StringType]] =
      ZIO.succeed(providerDetails)
    def getAttributeMapping
        : ZIO[Any, AwsError, Map[AttributeMappingKeyType, StringType]] =
      AwsError.unwrapOptionField("attributeMapping", attributeMapping)
    def getIdpIdentifiers: ZIO[Any, AwsError, List[IdpIdentifierType]] =
      AwsError.unwrapOptionField("idpIdentifiers", idpIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest
  ) extends zio.aws.cognitoidentityprovider.model.CreateIdentityProviderRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val providerName: ProviderNameTypeV2 =
      zio.aws.cognitoidentityprovider.model.primitives
        .ProviderNameTypeV2(impl.providerName())
    override val providerType
        : zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType =
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
        .wrap(impl.providerType())
    override val providerDetails: Map[StringType, StringType] = impl
      .providerDetails()
      .asScala
      .map({ case (key, value) =>
        (key: StringType) -> (value: StringType)
      })
      .toMap
    override val attributeMapping
        : Optional[Map[AttributeMappingKeyType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeMapping())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentityprovider.model.primitives
                .AttributeMappingKeyType(key) -> (value: StringType)
            })
            .toMap
        )
    override val idpIdentifiers: Optional[List[IdpIdentifierType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idpIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitoidentityprovider.model.primitives
              .IdpIdentifierType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest
  ): zio.aws.cognitoidentityprovider.model.CreateIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
