package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait CustomSMSSenderLambdaVersionType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType
}
object CustomSMSSenderLambdaVersionType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType
  ): zio.aws.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType.V1_0 =>
        val r = V1_0
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType.UNKNOWN_TO_SDK_VERSION
  }
  case object V1_0
      extends zio.aws.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType.V1_0
  }
}
