package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserAttributeUpdateSettingsType(
    attributesRequireVerificationBeforeUpdate: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType = {
    import UserAttributeUpdateSettingsType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType
      .builder()
      .optionallyWith(
        attributesRequireVerificationBeforeUpdate.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributesRequireVerificationBeforeUpdateWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType
      .wrap(buildAwsValue())
}
object UserAttributeUpdateSettingsType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType =
      zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType(
        attributesRequireVerificationBeforeUpdate.map(value => value)
      )
    def attributesRequireVerificationBeforeUpdate: Optional[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ]
    def getAttributesRequireVerificationBeforeUpdate: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.VerifiedAttributeType
    ]] = AwsError.unwrapOptionField(
      "attributesRequireVerificationBeforeUpdate",
      attributesRequireVerificationBeforeUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType
  ) extends zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.ReadOnly {
    override val attributesRequireVerificationBeforeUpdate: Optional[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributesRequireVerificationBeforeUpdate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.VerifiedAttributeType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType
  ): zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.ReadOnly =
    new Wrapper(impl)
}
