package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait RiskLevelType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType
}
object RiskLevelType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType
  ): zio.aws.cognitoidentityprovider.model.RiskLevelType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType.LOW =>
      val r = Low
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType.MEDIUM =>
      val r = Medium
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType.HIGH =>
      val r = High
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.RiskLevelType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType.UNKNOWN_TO_SDK_VERSION
  }
  case object Low extends zio.aws.cognitoidentityprovider.model.RiskLevelType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType.LOW
  }
  case object Medium
      extends zio.aws.cognitoidentityprovider.model.RiskLevelType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType.MEDIUM
  }
  case object High extends zio.aws.cognitoidentityprovider.model.RiskLevelType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RiskLevelType.HIGH
  }
}
