package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResendConfirmationCodeResponse(
    codeDeliveryDetails: Optional[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse = {
    import ResendConfirmationCodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse
      .builder()
      .optionallyWith(codeDeliveryDetails.map(value => value.buildAwsValue()))(
        _.codeDeliveryDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse
      .wrap(buildAwsValue())
}
object ResendConfirmationCodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse =
      zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse(
        codeDeliveryDetails.map(value => value.asEditable)
      )
    def codeDeliveryDetails: Optional[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ]
    def getCodeDeliveryDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ] = AwsError.unwrapOptionField("codeDeliveryDetails", codeDeliveryDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse
  ) extends zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse.ReadOnly {
    override val codeDeliveryDetails: Optional[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.codeDeliveryDetails())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse
  ): zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse.ReadOnly =
    new Wrapper(impl)
}
