package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLogDeliveryConfigurationResponse(
    logDeliveryConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse = {
    import GetLogDeliveryConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse
      .builder()
      .optionallyWith(
        logDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.logDeliveryConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse
      .wrap(buildAwsValue())
}
object GetLogDeliveryConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse =
      zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse(
        logDeliveryConfiguration.map(value => value.asEditable)
      )
    def logDeliveryConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType.ReadOnly
    ]
    def getLogDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "logDeliveryConfiguration",
      logDeliveryConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse
  ) extends zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse.ReadOnly {
    override val logDeliveryConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse
  ): zio.aws.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
