package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.BooleanType
import scala.jdk.CollectionConverters._
final case class ConfirmDeviceResponse(
    userConfirmationNecessary: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse = {
    import ConfirmDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse
      .builder()
      .optionallyWith(
        userConfirmationNecessary.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.userConfirmationNecessary)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse
      .wrap(buildAwsValue())
}
object ConfirmDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse =
      zio.aws.cognitoidentityprovider.model
        .ConfirmDeviceResponse(userConfirmationNecessary.map(value => value))
    def userConfirmationNecessary: Optional[BooleanType]
    def getUserConfirmationNecessary: ZIO[Any, AwsError, BooleanType] = AwsError
      .unwrapOptionField("userConfirmationNecessary", userConfirmationNecessary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse
  ) extends zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly {
    override val userConfirmationNecessary: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userConfirmationNecessary())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse
  ): zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly =
    new Wrapper(impl)
}
