package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.ArnType
import scala.jdk.CollectionConverters._
final case class CustomSMSLambdaVersionConfigType(
    lambdaVersion: zio.aws.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType,
    lambdaArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType = {
    import CustomSMSLambdaVersionConfigType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType
      .builder()
      .lambdaVersion(lambdaVersion.unwrap)
      .lambdaArn(ArnType.unwrap(lambdaArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType
      .wrap(buildAwsValue())
}
object CustomSMSLambdaVersionConfigType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType =
      zio.aws.cognitoidentityprovider.model
        .CustomSMSLambdaVersionConfigType(lambdaVersion, lambdaArn)
    def lambdaVersion
        : zio.aws.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType
    def lambdaArn: ArnType
    def getLambdaVersion: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType
    ] = ZIO.succeed(lambdaVersion)
    def getLambdaArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(lambdaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType
  ) extends zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType.ReadOnly {
    override val lambdaVersion
        : zio.aws.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType =
      zio.aws.cognitoidentityprovider.model.CustomSMSSenderLambdaVersionType
        .wrap(impl.lambdaVersion())
    override val lambdaArn: ArnType =
      zio.aws.cognitoidentityprovider.model.primitives.ArnType(impl.lambdaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType
  ): zio.aws.cognitoidentityprovider.model.CustomSMSLambdaVersionConfigType.ReadOnly =
    new Wrapper(impl)
}
