package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountRecoverySettingType(
    recoveryMechanisms: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.RecoveryOptionType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AccountRecoverySettingType = {
    import AccountRecoverySettingType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AccountRecoverySettingType
      .builder()
      .optionallyWith(
        recoveryMechanisms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recoveryMechanisms)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType
      .wrap(buildAwsValue())
}
object AccountRecoverySettingType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AccountRecoverySettingType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType =
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType(
        recoveryMechanisms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def recoveryMechanisms: Optional[
      List[zio.aws.cognitoidentityprovider.model.RecoveryOptionType.ReadOnly]
    ]
    def getRecoveryMechanisms: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.RecoveryOptionType.ReadOnly
    ]] = AwsError.unwrapOptionField("recoveryMechanisms", recoveryMechanisms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountRecoverySettingType
  ) extends zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly {
    override val recoveryMechanisms: Optional[
      List[zio.aws.cognitoidentityprovider.model.RecoveryOptionType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryMechanisms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.RecoveryOptionType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountRecoverySettingType
  ): zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly =
    new Wrapper(impl)
}
