package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class UpdateUserAttributesRequest(
    userAttributes: Iterable[
      zio.aws.cognitoidentityprovider.model.AttributeType
    ],
    accessToken: TokenModelType,
    clientMetadata: Optional[Map[StringType, StringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest = {
    import UpdateUserAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest
      .builder()
      .userAttributes(userAttributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateUserAttributesRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateUserAttributesRequest
      .wrap(buildAwsValue())
}
object UpdateUserAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UpdateUserAttributesRequest =
      zio.aws.cognitoidentityprovider.model.UpdateUserAttributesRequest(
        userAttributes.map { item =>
          item.asEditable
        },
        accessToken,
        clientMetadata.map(value => value)
      )
    def userAttributes
        : List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    def accessToken: TokenModelType
    def clientMetadata: Optional[Map[StringType, StringType]]
    def getUserAttributes: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = ZIO.succeed(userAttributes)
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest
  ) extends zio.aws.cognitoidentityprovider.model.UpdateUserAttributesRequest.ReadOnly {
    override val userAttributes
        : List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly] =
      impl
        .userAttributes()
        .asScala
        .map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }
        .toList
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
    override val clientMetadata: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest
  ): zio.aws.cognitoidentityprovider.model.UpdateUserAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
