package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  TokenModelType,
  AttributeNameType
}
import scala.jdk.CollectionConverters._
final case class DeleteUserAttributesRequest(
    userAttributeNames: Iterable[AttributeNameType],
    accessToken: TokenModelType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest = {
    import DeleteUserAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest
      .builder()
      .userAttributeNames(userAttributeNames.map { item =>
        AttributeNameType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DeleteUserAttributesRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeleteUserAttributesRequest
      .wrap(buildAwsValue())
}
object DeleteUserAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DeleteUserAttributesRequest =
      zio.aws.cognitoidentityprovider.model
        .DeleteUserAttributesRequest(userAttributeNames, accessToken)
    def userAttributeNames: List[AttributeNameType]
    def accessToken: TokenModelType
    def getUserAttributeNames: ZIO[Any, Nothing, List[AttributeNameType]] =
      ZIO.succeed(userAttributeNames)
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest
  ) extends zio.aws.cognitoidentityprovider.model.DeleteUserAttributesRequest.ReadOnly {
    override val userAttributeNames: List[AttributeNameType] = impl
      .userAttributeNames()
      .asScala
      .map { item =>
        zio.aws.cognitoidentityprovider.model.primitives.AttributeNameType(item)
      }
      .toList
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest
  ): zio.aws.cognitoidentityprovider.model.DeleteUserAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
