package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminEnableUserRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest = {
    import AdminEnableUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminEnableUserRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminEnableUserRequest
      .wrap(buildAwsValue())
}
object AdminEnableUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminEnableUserRequest =
      zio.aws.cognitoidentityprovider.model
        .AdminEnableUserRequest(userPoolId, username)
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminEnableUserRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest
  ): zio.aws.cognitoidentityprovider.model.AdminEnableUserRequest.ReadOnly =
    new Wrapper(impl)
}
