package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait FeedbackValueType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType
}
object FeedbackValueType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType
  ): zio.aws.cognitoidentityprovider.model.FeedbackValueType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType.VALID =>
      val r = Valid
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType.INVALID =>
      val r = Invalid
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.FeedbackValueType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object Valid
      extends zio.aws.cognitoidentityprovider.model.FeedbackValueType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType.VALID
  }
  case object Invalid
      extends zio.aws.cognitoidentityprovider.model.FeedbackValueType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType.INVALID
  }
}
