package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{DateType, StringType}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AuthEventType(
    eventId: Optional[StringType] = Optional.Absent,
    eventType: Optional[zio.aws.cognitoidentityprovider.model.EventType] =
      Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    eventResponse: Optional[
      zio.aws.cognitoidentityprovider.model.EventResponseType
    ] = Optional.Absent,
    eventRisk: Optional[zio.aws.cognitoidentityprovider.model.EventRiskType] =
      Optional.Absent,
    challengeResponses: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.ChallengeResponseType]
    ] = Optional.Absent,
    eventContextData: Optional[
      zio.aws.cognitoidentityprovider.model.EventContextDataType
    ] = Optional.Absent,
    eventFeedback: Optional[
      zio.aws.cognitoidentityprovider.model.EventFeedbackType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType = {
    import AuthEventType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType
      .builder()
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(eventResponse.map(value => value.unwrap))(_.eventResponse)
      .optionallyWith(eventRisk.map(value => value.buildAwsValue()))(
        _.eventRisk
      )
      .optionallyWith(
        challengeResponses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.challengeResponses)
      .optionallyWith(eventContextData.map(value => value.buildAwsValue()))(
        _.eventContextData
      )
      .optionallyWith(eventFeedback.map(value => value.buildAwsValue()))(
        _.eventFeedback
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AuthEventType.wrap(buildAwsValue())
}
object AuthEventType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.AuthEventType =
      zio.aws.cognitoidentityprovider.model.AuthEventType(
        eventId.map(value => value),
        eventType.map(value => value),
        creationDate.map(value => value),
        eventResponse.map(value => value),
        eventRisk.map(value => value.asEditable),
        challengeResponses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        eventContextData.map(value => value.asEditable),
        eventFeedback.map(value => value.asEditable)
      )
    def eventId: Optional[StringType]
    def eventType: Optional[zio.aws.cognitoidentityprovider.model.EventType]
    def creationDate: Optional[DateType]
    def eventResponse
        : Optional[zio.aws.cognitoidentityprovider.model.EventResponseType]
    def eventRisk
        : Optional[zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly]
    def challengeResponses: Optional[
      List[zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly]
    ]
    def eventContextData: Optional[
      zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly
    ]
    def eventFeedback: Optional[
      zio.aws.cognitoidentityprovider.model.EventFeedbackType.ReadOnly
    ]
    def getEventId: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getEventType
        : ZIO[Any, AwsError, zio.aws.cognitoidentityprovider.model.EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getEventResponse: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EventResponseType
    ] = AwsError.unwrapOptionField("eventResponse", eventResponse)
    def getEventRisk: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly
    ] = AwsError.unwrapOptionField("eventRisk", eventRisk)
    def getChallengeResponses: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly
    ]] = AwsError.unwrapOptionField("challengeResponses", challengeResponses)
    def getEventContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("eventContextData", eventContextData)
    def getEventFeedback: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EventFeedbackType.ReadOnly
    ] = AwsError.unwrapOptionField("eventFeedback", eventFeedback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType
  ) extends zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly {
    override val eventId: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => value: StringType)
    override val eventType
        : Optional[zio.aws.cognitoidentityprovider.model.EventType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventType())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.EventType.wrap(value)
        )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val eventResponse
        : Optional[zio.aws.cognitoidentityprovider.model.EventResponseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventResponse())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.EventResponseType.wrap(value)
        )
    override val eventRisk: Optional[
      zio.aws.cognitoidentityprovider.model.EventRiskType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventRisk())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EventRiskType.wrap(value)
      )
    override val challengeResponses: Optional[
      List[zio.aws.cognitoidentityprovider.model.ChallengeResponseType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.challengeResponses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.ChallengeResponseType.wrap(item)
        }.toList
      )
    override val eventContextData: Optional[
      zio.aws.cognitoidentityprovider.model.EventContextDataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventContextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EventContextDataType.wrap(value)
      )
    override val eventFeedback: Optional[
      zio.aws.cognitoidentityprovider.model.EventFeedbackType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventFeedback())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EventFeedbackType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType
  ): zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly = new Wrapper(
    impl
  )
}
