package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UserPoolIdType,
  GroupNameType
}
import scala.jdk.CollectionConverters._
final case class DeleteGroupRequest(
    groupName: GroupNameType,
    userPoolId: UserPoolIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest = {
    import DeleteGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DeleteGroupRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeleteGroupRequest
      .wrap(buildAwsValue())
}
object DeleteGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.DeleteGroupRequest =
      zio.aws.cognitoidentityprovider.model
        .DeleteGroupRequest(groupName, userPoolId)
    def groupName: GroupNameType
    def userPoolId: UserPoolIdType
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest
  ) extends zio.aws.cognitoidentityprovider.model.DeleteGroupRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .GroupNameType(impl.groupName())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest
  ): zio.aws.cognitoidentityprovider.model.DeleteGroupRequest.ReadOnly =
    new Wrapper(impl)
}
