package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.TokenModelType
import scala.jdk.CollectionConverters._
final case class DeleteUserRequest(accessToken: TokenModelType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest
      .builder()
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DeleteUserRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeleteUserRequest
      .wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.DeleteUserRequest =
      zio.aws.cognitoidentityprovider.model.DeleteUserRequest(accessToken)
    def accessToken: TokenModelType
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest
  ) extends zio.aws.cognitoidentityprovider.model.DeleteUserRequest.ReadOnly {
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest
  ): zio.aws.cognitoidentityprovider.model.DeleteUserRequest.ReadOnly =
    new Wrapper(impl)
}
